/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XMLStreamReaderInputStream;
import org.apache.camel.converter.jaxp.XMLStreamReaderReader;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class StaxConverter {
    private static final Logger LOG = LoggerFactory.getLogger(StaxConverter.class);
    private static final BlockingQueue<XMLInputFactory> INPUT_FACTORY_POOL;
    private static final BlockingQueue<XMLOutputFactory> OUTPUT_FACTORY_POOL;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventWriter createXMLEventWriter(OutputStream out, Exchange exchange) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLEventWriter xMLEventWriter = factory.createXMLEventWriter(IOHelper.buffered(out), IOHelper.getCharsetName(exchange));
            return xMLEventWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLEventWriter xMLEventWriter = factory.createXMLEventWriter(IOHelper.buffered(writer));
            return xMLEventWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLEventWriter xMLEventWriter = factory.createXMLEventWriter(result);
            return xMLEventWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, Exchange exchange) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(IOHelper.buffered(outputStream), IOHelper.getCharsetName(exchange));
            return xMLStreamWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(IOHelper.buffered(writer));
            return xMLStreamWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(result);
            return xMLStreamWriter;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(IOHelper.buffered(in));
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamReader createXMLStreamReader(InputStream in, Exchange exchange) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            String charsetName = IOHelper.getCharsetName(exchange, false);
            if (charsetName == null) {
                XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(IOHelper.buffered(in));
                return xMLStreamReader;
            }
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(IOHelper.buffered(in), charsetName);
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamReader createXMLStreamReader(File file, Exchange exchange) throws XMLStreamException, FileNotFoundException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(IOHelper.buffered(new FileInputStream(file)), IOHelper.getCharsetName(exchange));
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(IOHelper.buffered(reader));
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamReader createXMLStreamReader(Source in) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(in);
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLStreamReader createXMLStreamReader(String string) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(new StringReader(string));
            return xMLStreamReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLEventReader xMLEventReader = factory.createXMLEventReader(IOHelper.buffered(in));
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventReader createXMLEventReader(InputStream in, Exchange exchange) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            String charsetName = IOHelper.getCharsetName(exchange, false);
            if (charsetName == null) {
                XMLEventReader xMLEventReader = factory.createXMLEventReader(IOHelper.buffered(in));
                return xMLEventReader;
            }
            XMLEventReader xMLEventReader = factory.createXMLEventReader(IOHelper.buffered(in), charsetName);
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventReader createXMLEventReader(File file, Exchange exchange) throws XMLStreamException, FileNotFoundException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLEventReader xMLEventReader = factory.createXMLEventReader(IOHelper.buffered(new FileInputStream(file)), IOHelper.getCharsetName(exchange));
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLEventReader xMLEventReader = factory.createXMLEventReader(IOHelper.buffered(reader));
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLEventReader xMLEventReader = factory.createXMLEventReader(reader);
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public XMLEventReader createXMLEventReader(Source in) throws XMLStreamException {
        XMLInputFactory factory = this.getInputFactory();
        try {
            XMLEventReader xMLEventReader = factory.createXMLEventReader(in);
            return xMLEventReader;
        }
        finally {
            this.returnXMLInputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public InputStream createInputStream(XMLStreamReader reader, Exchange exchange) {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            String charsetName = IOHelper.getCharsetName(exchange, false);
            XMLStreamReaderInputStream xMLStreamReaderInputStream = new XMLStreamReaderInputStream(reader, charsetName, factory);
            return xMLStreamReaderInputStream;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public Reader createReader(XMLStreamReader reader, Exchange exchange) {
        XMLOutputFactory factory = this.getOutputFactory();
        try {
            XMLStreamReaderReader xMLStreamReaderReader = new XMLStreamReaderReader(reader, factory);
            return xMLStreamReaderReader;
        }
        finally {
            this.returnXMLOutputFactory(factory);
        }
    }

    private static boolean isWoodstox(Object factory) {
        return factory.getClass().getPackage().getName().startsWith("com.ctc.wstx");
    }

    private XMLInputFactory getXMLInputFactory() {
        XMLInputFactory f = (XMLInputFactory)INPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = StaxConverter.createXMLInputFactory(true);
        }
        return f;
    }

    private void returnXMLInputFactory(XMLInputFactory factory) {
        if (factory != this.inputFactory) {
            INPUT_FACTORY_POOL.offer(factory);
        }
    }

    private XMLOutputFactory getXMLOutputFactory() {
        XMLOutputFactory f = (XMLOutputFactory)OUTPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = XMLOutputFactory.newInstance();
        }
        return f;
    }

    private void returnXMLOutputFactory(XMLOutputFactory factory) {
        if (factory != this.outputFactory) {
            OUTPUT_FACTORY_POOL.offer(factory);
        }
    }

    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        StaxConverter.setProperty(factory, "javax.xml.stream.isNamespaceAware", nsAware);
        StaxConverter.setProperty(factory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        StaxConverter.setProperty(factory, "javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        StaxConverter.setProperty(factory, "javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Reading external entities is disabled");
            }
        });
        if (StaxConverter.isWoodstox(factory)) {
            LOG.debug("Created Woodstox XMLInputFactory: {}", (Object)factory);
        } else {
            LOG.info("Created XMLInputFactory: {}. DOMSource/DOMResult may have issues with {}. We suggest using Woodstox.", (Object)factory, (Object)factory);
        }
        return factory;
    }

    private static void setProperty(XMLInputFactory f, String p, Object o) {
        try {
            f.setProperty(p, o);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            return this.getXMLInputFactory();
        }
        return this.inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        if (this.outputFactory == null) {
            return this.getXMLOutputFactory();
        }
        return this.outputFactory;
    }

    public void setInputFactory(XMLInputFactory inputFactory) {
        this.inputFactory = inputFactory;
    }

    public void setOutputFactory(XMLOutputFactory outputFactory) {
        this.outputFactory = outputFactory;
    }

    static {
        int i = 20;
        try {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("org.apache.cxf.staxutils.pool-size", "-1");
                }
            });
            i = Integer.parseInt(s);
        }
        catch (Throwable t) {
            i = 20;
        }
        try {
            int cores = Runtime.getRuntime().availableProcessors();
            if (cores > i) {
                i = cores;
            }
        }
        catch (Throwable t) {
            i = 20;
        }
        if (i <= 0) {
            i = 20;
        }
        LOG.debug("StaxConverter pool size: {}", (Object)i);
        INPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLInputFactory>(i);
        OUTPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLOutputFactory>(i);
    }
}

