/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.transport.mqtt.MQTTCodec;
import org.apache.activemq.transport.ws.AbstractMQTTSocket;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSocket
extends AbstractMQTTSocket
implements MQTTCodec.MQTTFrameSink,
WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTSocket.class);
    private final int ORDERLY_CLOSE_TIMEOUT = 10;
    private Session session;
    private final AtomicBoolean receivedDisconnect = new AtomicBoolean();
    private final MQTTCodec codec = new MQTTCodec((MQTTCodec.MQTTFrameSink)this, this.getWireFormat());

    public MQTTSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        ByteSequence bytes = this.wireFormat.marshal((Object)command);
        try {
            this.session.getRemote().sendBytes(ByteBuffer.wrap(bytes.getData(), 0, bytes.getLength()));
        }
        catch (Exception e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketBinary(byte[] bytes, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for MQTTSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for MQTTSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            this.receiveCounter += length;
            this.codec.parse(new DataByteArrayInputStream(new Buffer(bytes, offset, length)), length);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int arg0, String arg1) {
        try {
            if (this.protocolLock.tryLock() || this.protocolLock.tryLock(10L, TimeUnit.SECONDS)) {
                LOG.debug("MQTT WebSocket closed: code[{}] message[{}]", (Object)arg0, (Object)arg1);
                if (!this.receivedDisconnect.get()) {
                    this.getProtocolConverter().onTransportError();
                }
                this.getProtocolConverter().onMQTTCommand(new DISCONNECT().encode());
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to close MQTT WebSocket cleanly", (Throwable)e);
        }
        finally {
            if (this.protocolLock.isHeldByCurrentThread()) {
                this.protocolLock.unlock();
            }
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.session.setIdleTimeout(Duration.ZERO);
    }

    public void onWebSocketError(Throwable arg0) {
    }

    public void onWebSocketText(String arg0) {
    }

    private static int getDefaultSendTimeOut() {
        return Integer.getInteger("org.apache.activemq.transport.ws.MQTTSocket.sendTimeout", 30);
    }

    public void onFrame(MQTTFrame mqttFrame) {
        try {
            if (mqttFrame.messageType() == 14) {
                this.receivedDisconnect.set(true);
            }
            this.getProtocolConverter().onMQTTCommand(mqttFrame);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }
}

