/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.util.concurrent.CompletableFuture;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.invocation.AbstractAsyncReturnValueHandler;
import reactor.core.publisher.Mono;

public class ReactiveReturnValueHandler
extends AbstractAsyncReturnValueHandler {
    private final ReactiveAdapterRegistry adapterRegistry;

    public ReactiveReturnValueHandler() {
        this(ReactiveAdapterRegistry.getSharedInstance());
    }

    public ReactiveReturnValueHandler(ReactiveAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.adapterRegistry.getAdapter(returnType.getParameterType()) != null;
    }

    @Override
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(returnType.getParameterType(), returnValue);
        return adapter != null && !adapter.isMultiValue() && !adapter.isNoValue();
    }

    @Override
    @Nullable
    public CompletableFuture<?> toCompletableFuture(Object returnValue, MethodParameter returnType) {
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(returnType.getParameterType(), returnValue);
        if (adapter != null) {
            return Mono.from(adapter.toPublisher(returnValue)).toFuture();
        }
        return null;
    }
}

