/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;

public class AMQPMirrorBrokerConnectionElement
extends AMQPBrokerConnectionElement {
    private static final long serialVersionUID = -6171198691682381614L;
    boolean durable = true;
    boolean queueCreation = true;
    boolean queueRemoval = true;
    boolean messageAcknowledgements = true;
    boolean sync = false;
    SimpleString mirrorSNF;
    String addressFilter;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public SimpleString getMirrorSNF() {
        return this.mirrorSNF;
    }

    public AMQPMirrorBrokerConnectionElement setMirrorSNF(SimpleString mirrorSNF) {
        this.mirrorSNF = mirrorSNF;
        return this;
    }

    public AMQPMirrorBrokerConnectionElement() {
        this.setType(AMQPBrokerConnectionAddressType.MIRROR);
    }

    public boolean isDurable() {
        return this.durable;
    }

    public AMQPMirrorBrokerConnectionElement setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public boolean isQueueCreation() {
        return this.queueCreation;
    }

    public AMQPMirrorBrokerConnectionElement setQueueCreation(boolean queueCreation) {
        this.queueCreation = queueCreation;
        return this;
    }

    public boolean isQueueRemoval() {
        return this.queueRemoval;
    }

    public AMQPMirrorBrokerConnectionElement setQueueRemoval(boolean queueRemoval) {
        this.queueRemoval = queueRemoval;
        return this;
    }

    @Override
    public AMQPMirrorBrokerConnectionElement setType(AMQPBrokerConnectionAddressType type) {
        super.setType(type);
        return this;
    }

    public boolean isMessageAcknowledgements() {
        return this.messageAcknowledgements;
    }

    public AMQPMirrorBrokerConnectionElement setMessageAcknowledgements(boolean messageAcknowledgements) {
        this.messageAcknowledgements = messageAcknowledgements;
        return this;
    }

    public String getAddressFilter() {
        return this.addressFilter;
    }

    public AMQPMirrorBrokerConnectionElement setAddressFilter(String addressFilter) {
        this.addressFilter = addressFilter;
        return this;
    }

    public boolean isSync() {
        return this.sync;
    }

    public AMQPMirrorBrokerConnectionElement setSync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public AMQPMirrorBrokerConnectionElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPMirrorBrokerConnectionElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.addressFilter, this.durable, this.messageAcknowledgements, this.mirrorSNF, this.queueCreation, this.queueRemoval, this.sync);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AMQPMirrorBrokerConnectionElement)) {
            return false;
        }
        AMQPMirrorBrokerConnectionElement other = (AMQPMirrorBrokerConnectionElement)obj;
        return Objects.equals(this.addressFilter, other.addressFilter) && Objects.equals(this.durable, other.durable) && Objects.equals(this.messageAcknowledgements, other.messageAcknowledgements) && Objects.equals(this.mirrorSNF, other.mirrorSNF) && Objects.equals(this.queueCreation, other.queueCreation) && Objects.equals(this.queueRemoval, other.queueRemoval) && Objects.equals(this.sync, other.sync);
    }
}

