/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.server.impl.AckReason;

public final class AckRetry {
    String nodeID;
    byte[] nodeIDBytes;
    long messageID;
    AckReason reason;
    int pageAttempts;
    int queueAttempts;
    int viewCount;
    private static Persister persister = new Persister();

    public int getViewCount() {
        return this.viewCount;
    }

    public int incrementViewCount() {
        return ++this.viewCount;
    }

    public static Persister getPersister() {
        return persister;
    }

    public String toString() {
        return "AckRetry{nodeID='" + this.nodeID + "', messageID=" + this.messageID + ", reason=" + String.valueOf((Object)this.reason) + ", pageAttempts=" + this.pageAttempts + ", queueAttempts=" + this.queueAttempts + ", viewCount=" + this.viewCount + "}";
    }

    public AckRetry() {
    }

    public AckRetry(String nodeID, long messageID, AckReason reason) {
        this.nodeID = nodeID;
        this.messageID = messageID;
        this.reason = reason;
    }

    public synchronized byte[] getNodeIDBytes() {
        if (this.nodeIDBytes == null) {
            this.nodeIDBytes = this.nodeID.getBytes(StandardCharsets.US_ASCII);
        }
        return this.nodeIDBytes;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public AckRetry setNodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public AckRetry setMessageID(long messageID) {
        this.messageID = messageID;
        return this;
    }

    public AckReason getReason() {
        return this.reason;
    }

    public AckRetry setReason(AckReason reason) {
        this.reason = reason;
        return this;
    }

    public int getPageAttempts() {
        return this.pageAttempts;
    }

    public int getQueueAttempts() {
        return this.queueAttempts;
    }

    public int attemptedPage() {
        return ++this.pageAttempts;
    }

    public int attemptedQueue() {
        return ++this.queueAttempts;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AckRetry)) {
            return false;
        }
        AckRetry other = (AckRetry)obj;
        return this.messageID == other.messageID && Objects.equals(this.nodeID, other.nodeID);
    }

    public int hashCode() {
        return Objects.hash(this.nodeID, this.messageID);
    }

    public static class Persister
    extends AbstractHashMapPersister<AckRetry, AckRetry> {
        private Persister() {
        }

        protected int getKeySize(AckRetry key) {
            return 4 + (key.getNodeID() == null ? 0 : key.getNodeIDBytes().length) + 8 + 1;
        }

        protected void encodeKey(ActiveMQBuffer buffer, AckRetry key) {
            if (key.getNodeID() == null) {
                buffer.writeInt(0);
            } else {
                byte[] temporaryNodeBytes = key.getNodeIDBytes();
                buffer.writeInt(temporaryNodeBytes.length);
                buffer.writeBytes(temporaryNodeBytes);
            }
            buffer.writeLong(key.messageID);
            buffer.writeByte(key.reason.getVal());
        }

        protected AckRetry decodeKey(ActiveMQBuffer buffer) {
            String nodeID;
            int sizeBytes = buffer.readInt();
            if (sizeBytes == 0) {
                nodeID = null;
            } else {
                byte[] temporaryNodeBytes = new byte[sizeBytes];
                buffer.readBytes(temporaryNodeBytes);
                nodeID = new String(temporaryNodeBytes, StandardCharsets.US_ASCII);
            }
            long messageID = buffer.readLong();
            AckReason reason = AckReason.fromValue(buffer.readByte());
            return new AckRetry(nodeID, messageID, reason);
        }

        protected int getValueSize(AckRetry value) {
            return 0;
        }

        protected void encodeValue(ActiveMQBuffer buffer, AckRetry value) {
        }

        protected AckRetry decodeValue(ActiveMQBuffer buffer, AckRetry key) {
            return key;
        }
    }
}

