/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.StreamMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAStreamMessage
extends ActiveMQRAMessage
implements StreamMessage {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ActiveMQRAStreamMessage(StreamMessage message, ActiveMQRASession session) {
        super((Message)message, session);
        logger.trace("constructor({}, {})", (Object)message, (Object)session);
    }

    public boolean readBoolean() throws JMSException {
        logger.trace("readBoolean()");
        return ((StreamMessage)this.message).readBoolean();
    }

    public byte readByte() throws JMSException {
        logger.trace("readByte()");
        return ((StreamMessage)this.message).readByte();
    }

    public int readBytes(byte[] value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("readBytes({})", (Object)Arrays.toString(value));
        }
        return ((StreamMessage)this.message).readBytes(value);
    }

    public char readChar() throws JMSException {
        logger.trace("readChar()");
        return ((StreamMessage)this.message).readChar();
    }

    public double readDouble() throws JMSException {
        logger.trace("readDouble()");
        return ((StreamMessage)this.message).readDouble();
    }

    public float readFloat() throws JMSException {
        logger.trace("readFloat()");
        return ((StreamMessage)this.message).readFloat();
    }

    public int readInt() throws JMSException {
        logger.trace("readInt()");
        return ((StreamMessage)this.message).readInt();
    }

    public long readLong() throws JMSException {
        logger.trace("readLong()");
        return ((StreamMessage)this.message).readLong();
    }

    public Object readObject() throws JMSException {
        logger.trace("readObject()");
        return ((StreamMessage)this.message).readObject();
    }

    public short readShort() throws JMSException {
        logger.trace("readShort()");
        return ((StreamMessage)this.message).readShort();
    }

    public String readString() throws JMSException {
        logger.trace("readString()");
        return ((StreamMessage)this.message).readString();
    }

    public void reset() throws JMSException {
        logger.trace("reset()");
        ((StreamMessage)this.message).reset();
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBoolean({})", (Object)value);
        }
        ((StreamMessage)this.message).writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeByte({})", (Object)value);
        }
        ((StreamMessage)this.message).writeByte(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBytes({}, {}, {})", new Object[]{Arrays.toString(value), offset, length});
        }
        ((StreamMessage)this.message).writeBytes(value, offset, length);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBytes({})", (Object)Arrays.toString(value));
        }
        ((StreamMessage)this.message).writeBytes(value);
    }

    public void writeChar(char value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeChar({})", (Object)Character.valueOf(value));
        }
        ((StreamMessage)this.message).writeChar(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeDouble({})", (Object)value);
        }
        ((StreamMessage)this.message).writeDouble(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeFloat({})", (Object)Float.valueOf(value));
        }
        ((StreamMessage)this.message).writeFloat(value);
    }

    public void writeInt(int value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeInt({})", (Object)value);
        }
        ((StreamMessage)this.message).writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeLong({})", (Object)value);
        }
        ((StreamMessage)this.message).writeLong(value);
    }

    public void writeObject(Object value) throws JMSException {
        logger.trace("writeObject({})", value);
        ((StreamMessage)this.message).writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeShort({})", (Object)value);
        }
        ((StreamMessage)this.message).writeShort(value);
    }

    public void writeString(String value) throws JMSException {
        logger.trace("writeString({})", (Object)value);
        ((StreamMessage)this.message).writeString(value);
    }
}

