/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;
import org.apache.activemq.artemis.utils.BufferHelper;

public class SessionBindingQueryResponseMessage_V4
extends SessionBindingQueryResponseMessage_V3 {
    protected boolean defaultPurgeOnNoConsumers;
    protected int defaultMaxConsumers;
    protected Boolean defaultExclusive;
    protected Boolean defaultLastValue;
    protected SimpleString defaultLastValueKey;
    protected Boolean defaultNonDestructive;
    protected Integer defaultConsumersBeforeDispatch;
    protected Long defaultDelayBeforeDispatch;

    public SessionBindingQueryResponseMessage_V4(boolean exists, List<SimpleString> queueNames, boolean autoCreateQueues, boolean autoCreateAddresses, boolean defaultPurgeOnNoConsumers, int defaultMaxConsumers, Boolean defaultExclusive, Boolean defaultLastValue, SimpleString defaultLastValueKey, Boolean defaultNonDestructive, Integer defaultConsumersBeforeDispatch, Long defaultDelayBeforeDispatch) {
        super((byte)-15);
        this.exists = exists;
        this.queueNames = queueNames;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreateAddresses = autoCreateAddresses;
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        this.defaultMaxConsumers = defaultMaxConsumers;
        this.defaultExclusive = defaultExclusive;
        this.defaultLastValue = defaultLastValue;
        this.defaultLastValueKey = defaultLastValueKey;
        this.defaultNonDestructive = defaultNonDestructive;
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
    }

    public SessionBindingQueryResponseMessage_V4() {
        super((byte)-15);
    }

    public SessionBindingQueryResponseMessage_V4(byte v) {
        super(v);
    }

    public boolean isDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers;
    }

    public int getDefaultMaxConsumers() {
        return this.defaultMaxConsumers;
    }

    public Boolean isDefaultExclusive() {
        return this.defaultExclusive;
    }

    public Boolean isDefaultLastValue() {
        return this.defaultLastValue;
    }

    public SimpleString getDefaultLastValueKey() {
        return this.defaultLastValueKey;
    }

    public Boolean isDefaultNonDestructive() {
        return this.defaultNonDestructive;
    }

    public Integer getDefaultConsumersBeforeDispatch() {
        return this.defaultConsumersBeforeDispatch;
    }

    public Long getDefaultDelayBeforeDispatch() {
        return this.defaultDelayBeforeDispatch;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.defaultPurgeOnNoConsumers);
        buffer.writeInt(this.defaultMaxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.defaultExclusive);
        BufferHelper.writeNullableBoolean(buffer, this.defaultLastValue);
        buffer.writeNullableSimpleString(this.defaultLastValueKey);
        BufferHelper.writeNullableBoolean(buffer, this.defaultNonDestructive);
        BufferHelper.writeNullableInteger(buffer, this.defaultConsumersBeforeDispatch);
        BufferHelper.writeNullableLong(buffer, this.defaultDelayBeforeDispatch);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.defaultPurgeOnNoConsumers = buffer.readBoolean();
        this.defaultMaxConsumers = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.defaultExclusive = BufferHelper.readNullableBoolean(buffer);
            this.defaultLastValue = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultLastValueKey = buffer.readNullableSimpleString();
            this.defaultNonDestructive = BufferHelper.readNullableBoolean(buffer);
            this.defaultConsumersBeforeDispatch = BufferHelper.readNullableInteger(buffer);
            this.defaultDelayBeforeDispatch = BufferHelper.readNullableLong(buffer);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultPurgeOnNoConsumers, this.defaultMaxConsumers, this.defaultExclusive, this.defaultLastValue, this.defaultLastValueKey, this.defaultNonDestructive, this.defaultConsumersBeforeDispatch, this.defaultDelayBeforeDispatch);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", defaultPurgeOnNoConsumers=" + this.defaultPurgeOnNoConsumers);
        sb.append(", defaultMaxConsumers=" + this.defaultMaxConsumers);
        sb.append(", defaultExclusive=" + this.defaultExclusive);
        sb.append(", defaultLastValue=" + this.defaultLastValue);
        sb.append(", defaultLastValueKey=" + String.valueOf(this.defaultLastValueKey));
        sb.append(", defaultNonDestructive=" + this.defaultNonDestructive);
        sb.append(", defaultConsumersBeforeDispatch=" + this.defaultConsumersBeforeDispatch);
        sb.append(", defaultDelayBeforeDispatch=" + this.defaultDelayBeforeDispatch);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionBindingQueryResponseMessage_V4)) {
            return false;
        }
        SessionBindingQueryResponseMessage_V4 other = (SessionBindingQueryResponseMessage_V4)obj;
        return this.defaultPurgeOnNoConsumers == other.defaultPurgeOnNoConsumers && this.defaultMaxConsumers == other.defaultMaxConsumers && Objects.equals(this.defaultExclusive, other.defaultExclusive) && Objects.equals(this.defaultLastValue, other.defaultLastValue) && Objects.equals(this.defaultLastValueKey, other.defaultLastValueKey) && Objects.equals(this.defaultNonDestructive, other.defaultNonDestructive) && Objects.equals(this.defaultConsumersBeforeDispatch, other.defaultConsumersBeforeDispatch) && Objects.equals(this.defaultDelayBeforeDispatch, other.defaultDelayBeforeDispatch);
    }
}

