/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.DelegatingEventLoopGroup;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;

public class SharedEventLoopGroup
extends DelegatingEventLoopGroup {
    private static SharedEventLoopGroup instance;
    private final AtomicReference<ScheduledFuture<?>> shutdown = new AtomicReference();
    private final AtomicLong channelFactoryCount = new AtomicLong();
    private final Promise<?> terminationPromise = ImmediateEventExecutor.INSTANCE.newPromise();

    private SharedEventLoopGroup(EventLoopGroup eventLoopGroup) {
        super(eventLoopGroup);
    }

    public static synchronized void forceShutdown() {
        if (instance != null) {
            instance.forEach(executor -> executor.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS));
            SharedEventLoopGroup.instance.channelFactoryCount.set(0L);
            instance = null;
        }
    }

    public static synchronized SharedEventLoopGroup getInstance(Function<ThreadFactory, EventLoopGroup> eventLoopGroupSupplier) {
        if (instance != null) {
            ScheduledFuture f = SharedEventLoopGroup.instance.shutdown.getAndSet(null);
            if (f != null) {
                f.cancel(false);
            }
        } else {
            instance = new SharedEventLoopGroup(eventLoopGroupSupplier.apply((ThreadFactory)SecurityManagerShim.doPrivileged(() -> new ActiveMQThreadFactory("client-remoting", true, ClientSessionFactoryImpl.class.getClassLoader()))));
        }
        SharedEventLoopGroup.instance.channelFactoryCount.incrementAndGet();
        return instance;
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationPromise;
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        Class<SharedEventLoopGroup> clazz = SharedEventLoopGroup.class;
        synchronized (SharedEventLoopGroup.class) {
            if (this.channelFactoryCount.decrementAndGet() == 0L) {
                this.shutdown.compareAndSet((ScheduledFuture<?>)null, (ScheduledFuture<?>)this.next().scheduleAtFixedRate(() -> {
                    Class<SharedEventLoopGroup> clazz = SharedEventLoopGroup.class;
                    synchronized (SharedEventLoopGroup.class) {
                        if (this.shutdown.get() != null) {
                            Future future = SharedEventLoopGroup.super.shutdownGracefully(l, l2, timeUnit);
                            future.addListener((GenericFutureListener)((FutureListener)future1 -> {
                                if (future1.isSuccess()) {
                                    this.terminationPromise.setSuccess(null);
                                } else {
                                    this.terminationPromise.setFailure(future1.cause());
                                }
                            }));
                            instance = null;
                        }
                        // ** MonitorExit[var6_4] (shouldn't be in output)
                        return;
                    }
                }, 10L, 10L, TimeUnit.SECONDS));
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return this.terminationPromise;
        }
    }
}

