/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.ForbiddenReason;
import io.hawt.web.ServletHelpers;
import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CORSFilter.class);
    public static final String ENABLE_CORS = "http.enableCORS";
    public static final String HAWTIO_ENABLE_CORS = "hawtio.http.enableCORS";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "http.accessControlAllowOrigin";
    public static final String HAWTIO_ACCESS_CONTROL_ALLOW_ORIGIN = "hawtio.http.accessControlAllowOrigin";
    private boolean enabled = false;
    private String headerValue = "*";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String enableCORS = this.getConfigParameter(ENABLE_CORS);
        this.enabled = Boolean.parseBoolean(enableCORS);
        if (!this.enabled) {
            LOG.debug("CORS disabled");
            return;
        }
        LOG.debug("CORS enabled");
        String origin = this.getConfigParameter(ACCESS_CONTROL_ALLOW_ORIGIN);
        if (origin != null) {
            this.headerValue = origin;
        }
        LOG.debug("Access-Control-Allow-Origin is configured: {}", (Object)this.headerValue);
    }

    @Override
    protected ForbiddenReason verifyHeaders(HttpServletRequest request) {
        if (!this.enabled) {
            return null;
        }
        String origin = request.getHeader("Origin");
        String reqScheme = request.getScheme();
        if (origin == null || "null".equals(origin) || "https".equals(reqScheme)) {
            return null;
        }
        try {
            String originScheme = new URL(origin).getProtocol();
            if ("http".equals(reqScheme) && "https".equals(originScheme)) {
                return ForbiddenReason.UNSECURED_CORS_REQUEST;
            }
        }
        catch (MalformedURLException e) {
            LOG.warn("Origin header value is malformed: {}", (Object)origin);
        }
        return null;
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!this.enabled) {
            return;
        }
        if ("OPTIONS".equals(request.getMethod())) {
            response.addHeader("Access-Control-Request-Method", "GET, POST, PUT, DELETE");
            String headers = request.getHeader("Access-Control-Request-Headers");
            if (headers != null) {
                response.addHeader("Access-Control-Allow-Headers", ServletHelpers.sanitizeHeader(headers));
            }
        }
        response.addHeader("Access-Control-Max-Age", String.valueOf(TimeUnit.DAYS.toSeconds(1L)));
        response.addHeader("Access-Control-Allow-Origin", this.headerValue);
    }
}

