/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

public class Address {
    private String _address;
    private boolean _passive;
    private String _scheme;
    private String _user;
    private String _pass;
    private String _host;
    private String _port;
    private String _name;

    public void clear() {
        this._passive = false;
        this._scheme = null;
        this._user = null;
        this._pass = null;
        this._host = null;
        this._port = null;
        this._name = null;
    }

    public Address() {
        this.clear();
    }

    public Address(String address) {
        int close;
        String hp;
        String uphp;
        int slash;
        this.clear();
        int start = 0;
        int schemeEnd = address.indexOf("://", start);
        if (schemeEnd >= 0) {
            this._scheme = address.substring(start, schemeEnd);
            start = schemeEnd + 3;
        }
        if ((slash = address.indexOf("/", start)) >= 0) {
            uphp = address.substring(start, slash);
            this._name = address.substring(slash + 1);
        } else {
            uphp = address.substring(start);
        }
        int at = uphp.indexOf(64);
        if (at >= 0) {
            String up = uphp.substring(0, at);
            hp = uphp.substring(at + 1);
            int colon = up.indexOf(58);
            if (colon >= 0) {
                this._user = up.substring(0, colon);
                this._pass = up.substring(colon + 1);
            } else {
                this._user = up;
            }
        } else {
            hp = uphp;
        }
        if (hp.startsWith("[") && (close = hp.indexOf(93)) >= 0) {
            this._host = hp.substring(1, close);
            if (hp.substring(close + 1).startsWith(":")) {
                this._port = hp.substring(close + 2);
            }
        }
        if (this._host == null) {
            int colon = hp.indexOf(58);
            if (colon >= 0) {
                this._host = hp.substring(0, colon);
                this._port = hp.substring(colon + 1);
            } else {
                this._host = hp;
            }
        }
        if (this._host.startsWith("~")) {
            this._host = this._host.substring(1);
            this._passive = true;
        }
    }

    public String toString() {
        String str = new String();
        if (this._scheme != null) {
            str = str + this._scheme + "://";
        }
        if (this._user != null) {
            str = str + this._user;
        }
        if (this._pass != null) {
            str = str + ":" + this._pass;
        }
        if (this._user != null || this._pass != null) {
            str = str + "@";
        }
        if (this._host != null) {
            str = this._host.contains(":") ? str + "[" + this._host + "]" : str + this._host;
        }
        if (this._port != null) {
            str = str + ":" + this._port;
        }
        if (this._name != null) {
            str = str + "/" + this._name;
        }
        return str;
    }

    public boolean isPassive() {
        return this._passive;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getUser() {
        return this._user;
    }

    public String getPass() {
        return this._pass;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getImpliedPort() {
        if (this._port == null) {
            return this.getDefaultPort();
        }
        return this.getPort();
    }

    public String getDefaultPort() {
        if ("amqps".equals(this._scheme)) {
            return "5671";
        }
        return "5672";
    }

    public String getName() {
        return this._name;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setPass(String pass) {
        this._pass = pass;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public void setName(String name) {
        this._name = name;
    }
}

