/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTVersion;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.commons.text.CaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final boolean DURABLE_MESSAGES = true;
    public static final boolean SESSION_AUTO_COMMIT_SENDS = true;
    public static final boolean SESSION_AUTO_COMMIT_ACKS = true;
    public static final boolean SESSION_PREACKNOWLEDGE = false;
    public static final boolean SESSION_XA = false;
    public static final boolean SESSION_AUTO_CREATE_QUEUE = false;
    public static final char DOLLAR = '$';
    public static final char HASH = '#';
    public static final char PLUS = '+';
    public static final char SLASH = '/';
    public static final String MQTT_SESSION_STORE = "$sys.mqtt.sessions";
    public static final String MQTT_RETAIN_ADDRESS_PREFIX = "$sys.mqtt.retain.";
    public static final SimpleString MQTT_QOS_LEVEL_KEY = SimpleString.of((String)"mqtt.qos.level");
    public static final SimpleString MQTT_MESSAGE_ID_KEY = SimpleString.of((String)"mqtt.message.id");
    public static final SimpleString MQTT_MESSAGE_TYPE_KEY = SimpleString.of((String)"mqtt.message.type");
    public static final SimpleString MQTT_MESSAGE_RETAIN_KEY = SimpleString.of((String)"mqtt.message.retain");
    public static final SimpleString MQTT_MESSAGE_RETAIN_INITIAL_DISTRIBUTION_KEY = SimpleString.of((String)"mqtt.message.retain.initial.distribution");
    public static final SimpleString MQTT_PAYLOAD_FORMAT_INDICATOR_KEY = SimpleString.of((String)"mqtt.payload.format.indicator");
    public static final SimpleString MQTT_RESPONSE_TOPIC_KEY = SimpleString.of((String)"mqtt.response.topic");
    public static final SimpleString MQTT_CORRELATION_DATA_KEY = SimpleString.of((String)"mqtt.correlation.data");
    public static final String MQTT_USER_PROPERTY_EXISTS_KEY = "mqtt.user.property.exists";
    public static final String MQTT_USER_PROPERTY_KEY_PREFIX = "mqtt.ordered.user.property.";
    public static final SimpleString MQTT_USER_PROPERTY_KEY_PREFIX_SIMPLE = SimpleString.of((String)"mqtt.ordered.user.property.");
    public static final SimpleString MQTT_CONTENT_TYPE_KEY = SimpleString.of((String)"mqtt.content.type");
    public static final String QOS2_MANAGEMENT_QUEUE_PREFIX = "$sys.mqtt.queue.qos2.";
    public static final String SHARED_SUBSCRIPTION_PREFIX = "$share/";
    public static final long FOUR_BYTE_INT_MAX = Long.decode("0xFFFFFFFF");
    public static final int TWO_BYTE_INT_MAX;
    public static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    public static final int MAX_PACKET_SIZE = 0xFFFFFFF;
    public static final long KEEP_ALIVE_ADJUSTMENT = 1500L;
    public static final int DEFAULT_SERVER_KEEP_ALIVE = 60;
    public static final int DEFAULT_TOPIC_ALIAS_MAX;
    public static final int DEFAULT_RECEIVE_MAXIMUM;
    public static final int DEFAULT_MAXIMUM_PACKET_SIZE = 0xFFFFFFF;
    public static final int DEFAULT_MAXIMUM_IN_FLIGHT_PUBLISH_MESSAGES;
    public static final WildcardConfiguration MQTT_WILDCARD;

    public static String getCoreQueueFromMqttTopic(String topicFilter, String clientId, WildcardConfiguration wildcardConfiguration) {
        Objects.requireNonNull(topicFilter, "MQTT topic filter must not be null");
        Objects.requireNonNull(wildcardConfiguration, "Broker wildcard configuration must not be null");
        if (MQTTUtil.isSharedSubscription(topicFilter)) {
            Pair<String, String> decomposed = MQTTUtil.decomposeSharedSubscriptionTopicFilter(topicFilter);
            return (String)decomposed.getA() + "." + MQTTUtil.getCoreAddressFromMqttTopic((String)decomposed.getB(), wildcardConfiguration);
        }
        Objects.requireNonNull(clientId, "MQTT client ID must not be null");
        return clientId + "." + MQTTUtil.getCoreAddressFromMqttTopic(topicFilter, wildcardConfiguration);
    }

    public static String getCoreAddressFromMqttTopic(String topicFilter, WildcardConfiguration wildcardConfiguration) {
        Objects.requireNonNull(topicFilter, "MQTT topic filter must not be null");
        Objects.requireNonNull(wildcardConfiguration, "Broker wildcard configuration must not be null");
        return MQTT_WILDCARD.convert(topicFilter, wildcardConfiguration);
    }

    public static String getCoreRetainAddressFromMqttTopic(String topicFilter, WildcardConfiguration wildcardConfiguration) {
        return MQTT_RETAIN_ADDRESS_PREFIX + MQTTUtil.getCoreAddressFromMqttTopic(topicFilter, wildcardConfiguration);
    }

    public static String getMqttTopicFromCoreAddress(String address, WildcardConfiguration wildcardConfiguration) {
        Objects.requireNonNull(address, "Address must not be null");
        Objects.requireNonNull(wildcardConfiguration, "Broker wildcard configuration must not be null");
        if (address.startsWith(MQTT_RETAIN_ADDRESS_PREFIX)) {
            address = address.substring(MQTT_RETAIN_ADDRESS_PREFIX.length());
        }
        return wildcardConfiguration.convert(address, MQTT_WILDCARD);
    }

    public static ICoreMessage createServerMessage(MQTTSession session, SimpleString address, MqttPublishMessage mqttPublishMessage) {
        String contentType;
        List userProperties;
        byte[] correlationData;
        String responseTopic;
        long id = session.getServer().getStorageManager().generateID();
        CoreMessage message = new CoreMessage(id, mqttPublishMessage.fixedHeader().remainingLength(), session.getCoreMessageObjectPools());
        message.setAddress(address);
        message.putBooleanProperty(MQTT_MESSAGE_RETAIN_KEY, mqttPublishMessage.fixedHeader().isRetain());
        message.putIntProperty(MQTT_QOS_LEVEL_KEY, mqttPublishMessage.fixedHeader().qosLevel().value());
        message.setType((byte)4);
        message.putStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME, session.getState().getClientId());
        MqttProperties properties = mqttPublishMessage.variableHeader() == null ? null : mqttPublishMessage.variableHeader().properties();
        Integer payloadIndicatorFormat = MQTTUtil.getProperty(Integer.class, properties, MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR);
        if (payloadIndicatorFormat != null) {
            message.putIntProperty(MQTT_PAYLOAD_FORMAT_INDICATOR_KEY, payloadIndicatorFormat.intValue());
        }
        if ((responseTopic = MQTTUtil.getProperty(String.class, properties, MqttProperties.MqttPropertyType.RESPONSE_TOPIC)) != null) {
            message.putStringProperty(MQTT_RESPONSE_TOPIC_KEY, responseTopic);
        }
        if ((correlationData = MQTTUtil.getProperty(byte[].class, properties, MqttProperties.MqttPropertyType.CORRELATION_DATA)) != null) {
            message.putBytesProperty(MQTT_CORRELATION_DATA_KEY, correlationData);
        }
        if ((userProperties = MQTTUtil.getProperty(List.class, properties, MqttProperties.MqttPropertyType.USER_PROPERTY)) != null && !userProperties.isEmpty()) {
            message.putIntProperty(MQTT_USER_PROPERTY_EXISTS_KEY, userProperties.size());
            for (int i = 0; i < userProperties.size(); ++i) {
                String key = MQTT_USER_PROPERTY_KEY_PREFIX + i + "." + ((MqttProperties.StringPair)userProperties.get((int)i)).key;
                message.putStringProperty(key, ((MqttProperties.StringPair)userProperties.get((int)i)).value);
            }
        }
        if ((contentType = MQTTUtil.getProperty(String.class, properties, MqttProperties.MqttPropertyType.CONTENT_TYPE)) != null) {
            message.putStringProperty(MQTT_CONTENT_TYPE_KEY, contentType);
        }
        long time = System.currentTimeMillis();
        message.setTimestamp(time);
        Integer messageExpiryInterval = MQTTUtil.getProperty(Integer.class, properties, MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL);
        if (messageExpiryInterval != null) {
            message.setExpiration(time + (long)(messageExpiryInterval * 1000));
        }
        return message;
    }

    public static Message createServerMessageFromByteBuf(MQTTSession session, SimpleString address, MqttPublishMessage mqttPublishMessage) {
        ICoreMessage message = MQTTUtil.createServerMessage(session, address, mqttPublishMessage);
        ByteBuf payload = mqttPublishMessage.payload();
        message.getBodyBuffer().writeBytes(payload, 0, payload.readableBytes());
        return message;
    }

    public static void logMessage(MQTTSessionState state, MqttMessage message, boolean inbound, MQTTVersion version) {
        if (logger.isTraceEnabled()) {
            StringBuilder log = new StringBuilder("MQTT(");
            if (state != null) {
                log.append(state.getClientId());
            }
            if (inbound) {
                log.append("): IN << ");
            } else {
                log.append("): OUT >> ");
            }
            if (message.fixedHeader() != null) {
                log.append(message.fixedHeader().messageType().toString());
                if (message.variableHeader() instanceof MqttMessageIdVariableHeader) {
                    log.append("(" + ((MqttMessageIdVariableHeader)message.variableHeader()).messageId() + ")");
                }
                switch (message.fixedHeader().messageType()) {
                    case PUBLISH: {
                        MqttPublishVariableHeader publishHeader = (MqttPublishVariableHeader)message.variableHeader();
                        String topicName = publishHeader.topicName();
                        if (topicName == null || topicName.isEmpty()) {
                            topicName = "<empty>";
                        }
                        log.append("(" + publishHeader.packetId() + ")").append(" topic=" + topicName).append(", qos=" + message.fixedHeader().qosLevel().value()).append(", retain=" + message.fixedHeader().isRetain()).append(", dup=" + message.fixedHeader().isDup()).append(", remainingLength=" + message.fixedHeader().remainingLength());
                        for (MqttProperties.MqttProperty property : ((MqttPublishMessage)message).variableHeader().properties().listAll()) {
                            Object value = property.value();
                            if (value != null) {
                                ArrayList list;
                                if (value instanceof byte[]) {
                                    byte[] bytes = (byte[])value;
                                    value = new String(bytes, StandardCharsets.UTF_8);
                                } else if (value instanceof ArrayList && !(list = (ArrayList)value).isEmpty() && list.get(0) instanceof MqttProperties.StringPair) {
                                    StringBuilder userProperties = new StringBuilder();
                                    userProperties.append("[");
                                    for (MqttProperties.StringPair pair : (ArrayList)value) {
                                        userProperties.append(pair.key).append(": ").append(pair.value).append(", ");
                                    }
                                    userProperties.delete(userProperties.length() - 2, userProperties.length());
                                    userProperties.append("]");
                                    value = userProperties.toString();
                                }
                            }
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + String.valueOf(value));
                        }
                        log.append(", payload=" + MQTTUtil.getPayloadForLogging((MqttPublishMessage)message, 256));
                        break;
                    }
                    case CONNECT: {
                        MqttConnectVariableHeader connectHeader = (MqttConnectVariableHeader)message.variableHeader();
                        MqttConnectPayload payload = ((MqttConnectMessage)message).payload();
                        log.append(" protocol=(").append(connectHeader.name()).append(", ").append(connectHeader.version()).append(")").append(", hasPassword=").append(connectHeader.hasPassword()).append(", isCleanStart=").append(connectHeader.isCleanSession()).append(", keepAliveTimeSeconds=").append(connectHeader.keepAliveTimeSeconds()).append(", clientIdentifier=").append(payload.clientIdentifier()).append(", hasUserName=").append(connectHeader.hasUserName()).append(", isWillFlag=").append(connectHeader.isWillFlag());
                        if (connectHeader.isWillFlag()) {
                            log.append(", willQos=").append(connectHeader.willQos()).append(", isWillRetain=").append(connectHeader.isWillRetain()).append(", willTopic=").append(payload.willTopic());
                        }
                        for (MqttProperties.MqttProperty property : connectHeader.properties().listAll()) {
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + String.valueOf(property.value()));
                        }
                        break;
                    }
                    case CONNACK: {
                        MqttConnAckVariableHeader connackHeader = (MqttConnAckVariableHeader)message.variableHeader();
                        log.append(" connectReasonCode=").append(MQTTUtil.formatByte(connackHeader.connectReturnCode().byteValue())).append(", sessionPresent=").append(connackHeader.isSessionPresent());
                        for (MqttProperties.MqttProperty property : connackHeader.properties().listAll()) {
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + String.valueOf(property.value()));
                        }
                        break;
                    }
                    case SUBSCRIBE: {
                        for (MqttTopicSubscription sub : ((MqttSubscribeMessage)message).payload().topicSubscriptions()) {
                            log.append("\n\ttopic: ").append(sub.topicName()).append(", qos: ").append(sub.qualityOfService()).append(", nolocal: ").append(sub.option().isNoLocal()).append(", retainHandling: ").append(sub.option().retainHandling()).append(", isRetainAsPublished: ").append(sub.option().isRetainAsPublished());
                        }
                        break;
                    }
                    case SUBACK: {
                        for (Integer qos : ((MqttSubAckMessage)message).payload().grantedQoSLevels()) {
                            log.append("\n\t" + qos);
                        }
                        break;
                    }
                    case UNSUBSCRIBE: {
                        for (String topic : ((MqttUnsubscribeMessage)message).payload().topics()) {
                            log.append("\n\t" + topic);
                        }
                        break;
                    }
                    case PUBACK: {
                        break;
                    }
                    case PUBREC: 
                    case PUBREL: 
                    case PUBCOMP: {
                        if (version != MQTTVersion.MQTT_5) break;
                        MqttPubReplyMessageVariableHeader pubReplyVariableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
                        log.append(" reasonCode=").append(MQTTUtil.formatByte(pubReplyVariableHeader.reasonCode()));
                        break;
                    }
                    case DISCONNECT: {
                        if (version != MQTTVersion.MQTT_5) break;
                        MqttReasonCodeAndPropertiesVariableHeader disconnectVariableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
                        log.append(" reasonCode=").append(MQTTUtil.formatByte(disconnectVariableHeader.reasonCode()));
                    }
                }
                logger.trace(log.toString());
            }
        }
    }

    private static String formatByte(byte bite) {
        return String.format("0x%02X ", bite);
    }

    private static String formatCase(String string) {
        return CaseUtils.toCamelCase((String)string, (boolean)false, (char[])new char[]{'_'});
    }

    private static String getPayloadForLogging(MqttPublishMessage message, int maxPayloadLogSize) {
        if (message.payload() == null) {
            return "<empty>";
        }
        String publishPayload = message.payload().toString(StandardCharsets.UTF_8);
        if (publishPayload.isEmpty()) {
            return "<empty>";
        }
        return publishPayload.length() > maxPayloadLogSize ? publishPayload.substring(0, maxPayloadLogSize) : publishPayload;
    }

    public static int calculateRemainingLength(String topicName, MqttProperties properties, ByteBuf payload) {
        int size = 0;
        int PACKET_ID_SIZE = 2;
        size += 2;
        size += ByteBufUtil.utf8Bytes((CharSequence)topicName);
        size += MQTTUtil.calculatePublishPropertiesSize(properties);
        return size += payload.resetReaderIndex().readableBytes();
    }

    private static int calculatePublishPropertiesSize(MqttProperties properties) {
        if (properties == null) {
            return 0;
        }
        int size = 0;
        for (MqttProperties.MqttProperty property : properties.listAll()) {
            MqttProperties.MqttPropertyType propertyType = MqttProperties.MqttPropertyType.valueOf((int)property.propertyId());
            size += (switch (propertyType) {
                case MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + 1;
                case MqttProperties.MqttPropertyType.TOPIC_ALIAS -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + 2;
                case MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + 4;
                case MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + MQTTUtil.calculateVariableByteIntegerSize((Integer)((MqttProperties.IntegerProperty)property).value());
                case MqttProperties.MqttPropertyType.CONTENT_TYPE, MqttProperties.MqttPropertyType.RESPONSE_TOPIC -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)property).value()));
                case MqttProperties.MqttPropertyType.USER_PROPERTY -> {
                    int userPropertySize = 0;
                    for (MqttProperties.StringPair pair : (List)((MqttProperties.UserProperties)property).value()) {
                        userPropertySize += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                        userPropertySize += ByteBufUtil.utf8Bytes((CharSequence)pair.key);
                        userPropertySize += ByteBufUtil.utf8Bytes((CharSequence)pair.value);
                    }
                    yield userPropertySize;
                }
                case MqttProperties.MqttPropertyType.CORRELATION_DATA -> MQTTUtil.calculateVariableByteIntegerSize(property.propertyId()) + 2 + ((byte[])((MqttProperties.BinaryProperty)property).value()).length;
                default -> throw new EncoderException("Unknown property type: " + String.valueOf(propertyType));
            });
        }
        size += MQTTUtil.calculateVariableByteIntegerSize(size);
        return size;
    }

    public static int calculateMessageSize(MqttPublishMessage message) {
        return 1 + MQTTUtil.calculateVariableByteIntegerSize(message.fixedHeader().remainingLength()) + message.fixedHeader().remainingLength();
    }

    private static int calculateVariableByteIntegerSize(int vbi) {
        int count = 0;
        do {
            ++count;
        } while ((vbi /= 128) > 0);
        return count;
    }

    public static <T> T getProperty(Class<T> type, MqttProperties properties, MqttProperties.MqttPropertyType propertyName) {
        return MQTTUtil.getProperty(type, properties, propertyName, null);
    }

    public static <T> T getProperty(Class<T> type, MqttProperties properties, MqttProperties.MqttPropertyType propertyName, T defaultReturnValue) {
        MqttProperties.MqttProperty o;
        if (properties != null && (o = properties.getProperty(propertyName.value())) != null) {
            try {
                return type.cast(o.value());
            }
            catch (ClassCastException e) {
                MQTTLogger.LOGGER.failedToCastProperty(propertyName.toString());
                throw e;
            }
        }
        return defaultReturnValue == null ? null : (T)defaultReturnValue;
    }

    public static Pair<String, String> decomposeSharedSubscriptionTopicFilter(String topicFilter) {
        if (MQTTUtil.isSharedSubscription(topicFilter)) {
            int prefix = SHARED_SUBSCRIPTION_PREFIX.length();
            String shareName = topicFilter.substring(prefix, topicFilter.indexOf(47, prefix));
            String parsedTopicName = topicFilter.substring(topicFilter.indexOf(47, prefix) + 1);
            return new Pair((Object)shareName, (Object)parsedTopicName);
        }
        return new Pair(null, (Object)topicFilter);
    }

    public static boolean isSharedSubscription(String topicFilter) {
        return topicFilter.startsWith(SHARED_SUBSCRIPTION_PREFIX);
    }

    public static void sendMessageDirectlyToQueue(StorageManager storageManager, PostOffice postOffice, Message message, Queue queue, Transaction incomingTx) throws Exception {
        Transaction tx = incomingTx;
        if (incomingTx == null) {
            tx = new TransactionImpl(storageManager);
            tx.setAsync(true);
        }
        RoutingContextImpl context = new RoutingContextImpl(tx);
        queue.route(message, (RoutingContext)context);
        postOffice.processRoute(message, (RoutingContext)context, false);
        if (incomingTx == null) {
            tx.commit();
        }
    }

    static {
        DEFAULT_TOPIC_ALIAS_MAX = TWO_BYTE_INT_MAX = Integer.decode("0xFFFF").intValue();
        DEFAULT_RECEIVE_MAXIMUM = TWO_BYTE_INT_MAX;
        DEFAULT_MAXIMUM_IN_FLIGHT_PUBLISH_MESSAGES = TWO_BYTE_INT_MAX;
        MQTT_WILDCARD = new WildcardConfiguration().setDelimiter('/').setAnyWords('#').setSingleWord('+');
    }
}

