/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;

public class JMSConnectionOptions
extends ConnectionOptions {
    private JMSFactoryType factoryType = JMSFactoryType.CF;

    public JMSFactoryType getFactoryTypeEnum() {
        return this.factoryType;
    }

    public String getType() {
        return this.factoryType.toString();
    }

    public void setType(String type) {
        this.factoryType = JMSConnectionOptions.convertCFType(type);
        if (this.factoryType == null) {
            this.factoryType = JMSFactoryType.CF;
        }
    }

    public static JMSFactoryType convertCFType(String type) {
        try {
            if (type == null) {
                return JMSFactoryType.CF;
            }
            return Enum.valueOf(JMSFactoryType.class, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "JMSConnectionOptions{, factoryType=" + String.valueOf((Object)this.factoryType) + "}";
    }
}

