/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import java.util.Objects;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class User {
    final String user;
    String password;

    public User(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.user, other.user);
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    public boolean isValid(String user, String password) {
        if (user == null) {
            return false;
        }
        return this.user.equals(user) && PasswordMaskingUtil.getHashProcessor((String)this.password).compare(password != null ? password.toCharArray() : null, this.password);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

