/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;

public interface FederatedQueueConsumer
extends MessageHandler {
    public static final String FEDERATION_NAME = "federation-name";
    public static final String FEDERATION_UPSTREAM_NAME = "federation-upstream-name";

    public static int getNextDelay(int delay, int delayMultiplier, int delayMax) {
        int nextDelay;
        if (delay == 0) {
            nextDelay = 1;
        } else {
            nextDelay = delay * delayMultiplier;
            if (nextDelay > delayMax) {
                nextDelay = delayMax;
            }
        }
        return nextDelay;
    }

    public FederationUpstream getFederationUpstream();

    public Federation getFederation();

    public FederatedConsumerKey getKey();

    public ClientSession getClientSession();

    public int incrementCount();

    public int decrementCount();

    public void start();

    public void close();
}

