/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.HdrHistogram.SingleWriterRecorder;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.RecordingMessageListener;

public final class MessageListenerBenchmark
implements BenchmarkService {
    private final ConnectionFactory factory;
    private final MicrosTimeProvider timeProvider;
    private final int consumers;
    private final boolean canDelaySetMessageCount;
    private final int connections;
    private final String clientID;
    private final Destination[] destinations;
    private final int sharedSubscription;
    private final boolean durableSubscription;
    private final long messageCount;
    private final boolean transaction;
    private Set<Connection> jmsConnections;
    private boolean started;
    private boolean closed;
    private MessageCountLimiter msgCountLimiter;
    private List<RecordingMessageListener> listeners;
    private AtomicBoolean fatalException;
    private List<Runnable> silentUnsubscribe;

    public MessageListenerBenchmark(ConnectionFactory factory, MicrosTimeProvider timeProvider, int consumers, long messageCount, int connections, String clientID, Destination[] destinations, boolean transaction, int sharedSubscription, boolean durableSubscription, boolean canDelayMessageCount) {
        this.factory = factory;
        this.timeProvider = timeProvider;
        this.consumers = consumers;
        this.messageCount = messageCount;
        this.connections = connections;
        this.clientID = clientID;
        this.destinations = destinations;
        this.transaction = transaction;
        this.sharedSubscription = sharedSubscription;
        this.durableSubscription = durableSubscription;
        this.started = false;
        this.closed = false;
        this.jmsConnections = new HashSet<Connection>(connections);
        this.canDelaySetMessageCount = canDelayMessageCount;
        this.listeners = null;
        this.fatalException = null;
        this.silentUnsubscribe = null;
    }

    public synchronized RecordingMessageListener[] getListeners() {
        return this.listeners == null ? null : this.listeners.toArray(new RecordingMessageListener[this.listeners.size()]);
    }

    @Override
    public synchronized boolean anyError() {
        if (this.fatalException == null) {
            return false;
        }
        return this.fatalException.get();
    }

    @Override
    public synchronized boolean isRunning() {
        if (!this.started || this.closed) {
            return false;
        }
        if (this.fatalException.get()) {
            return false;
        }
        if (this.msgCountLimiter == null) {
            return true;
        }
        return !this.msgCountLimiter.isLimitReached();
    }

    public synchronized void setMessageCount(long messageCount) {
        if (!this.started || this.closed) {
            return;
        }
        this.msgCountLimiter.setMessageLimit(messageCount);
    }

    @Override
    public synchronized MessageListenerBenchmark start() {
        AtomicBoolean signalBrokenConnection;
        if (this.started) {
            return this;
        }
        this.started = true;
        this.closed = false;
        AtomicLong consumerId = new AtomicLong(1L);
        this.fatalException = signalBrokenConnection = new AtomicBoolean(false);
        Connection[] jmsConnections = new Connection[this.connections];
        for (int i = 0; i < this.connections; ++i) {
            try {
                Connection connection2 = this.factory.createConnection();
                if (this.clientID != null) {
                    if (this.connections > 1) {
                        connection2.setClientID(this.clientID + i);
                    } else {
                        connection2.setClientID(this.clientID);
                    }
                }
                connection2.setExceptionListener(ignore -> signalBrokenConnection.set(true));
                jmsConnections[i] = connection2;
                continue;
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        this.jmsConnections.addAll(Arrays.asList(jmsConnections));
        this.jmsConnections.forEach(connection -> {
            try {
                connection.start();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        });
        int connectionSequence = 0;
        int totalListeners = this.consumers * this.destinations.length * Math.max(this.sharedSubscription, 1);
        this.listeners = new ArrayList<RecordingMessageListener>(totalListeners);
        if (this.messageCount > 0L) {
            this.msgCountLimiter = new MessageCountLimiter().setMessageLimit(this.messageCount);
        } else if (this.canDelaySetMessageCount) {
            this.msgCountLimiter = new MessageCountLimiter();
        }
        if (this.durableSubscription) {
            this.silentUnsubscribe = new ArrayList<Runnable>();
        }
        for (int i = 0; i < this.destinations.length; ++i) {
            Destination destination = this.destinations[i];
            if (this.sharedSubscription == 0) {
                ArrayDeque destinationListeners = new ArrayDeque(this.consumers);
                this.createListeners(destinationListeners, consumerId, destination, this.consumers);
                this.listeners.addAll(destinationListeners);
                try {
                    for (int consumerIndex = 0; consumerIndex < this.consumers; ++consumerIndex) {
                        MessageConsumer consumer;
                        Connection connection3 = jmsConnections[connectionSequence % this.connections];
                        ++connectionSequence;
                        Session session = connection3.createSession(this.transaction ? 0 : 1);
                        if (this.durableSubscription) {
                            Topic topic = (Topic)destination;
                            consumer = session.createDurableConsumer((Topic)destination, topic.getTopicName() + consumerIndex);
                        } else {
                            consumer = session.createConsumer(destination);
                        }
                        consumer.setMessageListener((MessageListener)destinationListeners.remove());
                    }
                    continue;
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }
            int listenersPerDestination = this.sharedSubscription * this.consumers;
            ArrayDeque destinationListeners = new ArrayDeque(listenersPerDestination);
            this.createListeners(destinationListeners, consumerId, destination, listenersPerDestination);
            this.listeners.addAll(destinationListeners);
            try {
                String topicName = ((Topic)destination).getTopicName();
                for (int subscriptionIndex = 0; subscriptionIndex < this.sharedSubscription; ++subscriptionIndex) {
                    Connection connection4 = null;
                    if (this.clientID != null) {
                        connection4 = jmsConnections[connectionSequence % this.connections];
                        assert (connection4.getClientID() != null);
                        ++connectionSequence;
                    }
                    for (int consumerIndex = 0; consumerIndex < this.consumers; ++consumerIndex) {
                        MessageConsumer consumer;
                        if (this.clientID == null) {
                            assert (connection4 == null);
                            connection4 = jmsConnections[connectionSequence % this.connections];
                            ++connectionSequence;
                        }
                        Session session = connection4.createSession(this.transaction ? 0 : 1);
                        if (this.durableSubscription) {
                            String subscriptionName = topicName + subscriptionIndex;
                            consumer = session.createSharedDurableConsumer((Topic)destination, subscriptionName);
                            this.silentUnsubscribe.add(() -> {
                                try {
                                    session.unsubscribe(subscriptionName);
                                }
                                catch (JMSException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        } else {
                            consumer = session.createSharedConsumer((Topic)destination, topicName + subscriptionIndex);
                        }
                        consumer.setMessageListener((MessageListener)destinationListeners.remove());
                    }
                }
                continue;
            }
            catch (JMSException fatal) {
                throw new RuntimeException(fatal);
            }
        }
        return this;
    }

    private void createListeners(Collection<? super RecordingMessageListener> listeners, AtomicLong consumerId, Destination destination, int count) {
        for (int c = 0; c < count; ++c) {
            listeners.add(new RecordingMessageListener(consumerId.getAndIncrement(), destination, this.transaction, new AtomicLong(0L), this.msgCountLimiter == null ? null : this.msgCountLimiter::onMessageReceived, this.timeProvider, new SingleWriterRecorder(2), this.fatalException));
        }
    }

    @Override
    public synchronized void close() {
        if (!this.started || this.closed) {
            return;
        }
        this.listeners = null;
        this.started = false;
        this.closed = true;
        this.msgCountLimiter = null;
        this.fatalException = null;
        if (this.silentUnsubscribe != null) {
            this.silentUnsubscribe.forEach(Runnable::run);
            this.silentUnsubscribe = null;
        }
        this.jmsConnections.forEach(connection -> {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        });
        this.jmsConnections.clear();
    }

    public static final class MessageCountLimiter {
        private volatile long messageLimit = Long.MAX_VALUE;
        private final LongAdder totalMessagesReceived = new LongAdder();

        MessageCountLimiter() {
        }

        public MessageCountLimiter setMessageLimit(long messageLimit) {
            this.messageLimit = messageLimit;
            return this;
        }

        public boolean isLimitReached() {
            return this.totalMessagesReceived.sum() >= this.messageLimit;
        }

        public void onMessageReceived() {
            this.totalMessagesReceived.increment();
        }
    }
}

