/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.netty.channel.EventLoopGroup;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmark;

public class ProducerBenchmarkBuilder {
    private ConnectionFactory factory;
    private MicrosTimeProvider timeProvider;
    private EventLoopGroup loopGroup;
    private int producers;
    private long messageCount;
    private String group;
    private long ttl;
    private int messageSize;
    private Destination[] destinations;
    private boolean persistent;
    private long maxPending;
    private long transactionCapacity;
    private Long messageRate;
    private boolean sharedConnections;
    private boolean enableMessageID;
    private boolean enableTimestamp;

    public ProducerBenchmarkBuilder setFactory(ConnectionFactory factory) {
        this.factory = factory;
        return this;
    }

    public ProducerBenchmarkBuilder setTimeProvider(MicrosTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    public ProducerBenchmarkBuilder setLoopGroup(EventLoopGroup loopGroup) {
        this.loopGroup = loopGroup;
        return this;
    }

    public ProducerBenchmarkBuilder setProducers(int producers) {
        this.producers = producers;
        return this;
    }

    public ProducerBenchmarkBuilder setMessageCount(long messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public ProducerBenchmarkBuilder setSharedConnections(boolean sharedConnections) {
        this.sharedConnections = sharedConnections;
        return this;
    }

    public ProducerBenchmarkBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public ProducerBenchmarkBuilder setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public ProducerBenchmarkBuilder setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public ProducerBenchmarkBuilder setDestinations(Destination[] destinations) {
        this.destinations = destinations;
        return this;
    }

    public ProducerBenchmarkBuilder setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public ProducerBenchmarkBuilder setMaxPending(long maxPending) {
        this.maxPending = maxPending;
        return this;
    }

    public ProducerBenchmarkBuilder setTransactionCapacity(long transactionCapacity) {
        this.transactionCapacity = transactionCapacity;
        return this;
    }

    public ProducerBenchmarkBuilder setMessageRate(Long messageRate) {
        this.messageRate = messageRate;
        return this;
    }

    public ProducerBenchmarkBuilder setEnableTimestamp(boolean enableTimestamp) {
        this.enableTimestamp = enableTimestamp;
        return this;
    }

    public ProducerBenchmarkBuilder setEnableMessageID(boolean enableMessageID) {
        this.enableMessageID = enableMessageID;
        return this;
    }

    public ProducerBenchmark createProducerBenchmark() {
        return new ProducerBenchmark(this.factory, this.timeProvider, this.loopGroup, this.producers, this.messageCount, this.sharedConnections, this.group, this.ttl, this.messageSize, this.destinations, this.persistent, this.maxPending, this.transactionCapacity, this.messageRate, this.enableMessageID, this.enableTimestamp);
    }
}

