/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.cast;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.printer.adm.APrintVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.ResettableByteArrayOutputStream;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.util.string.UTF8StringWriter;

class ARecordCaster {
    private final PointableAllocator allocator = new PointableAllocator();
    private final List<IVisitablePointable> reqFieldNames = new ArrayList<IVisitablePointable>();
    private final List<IVisitablePointable> reqFieldTypeTags = new ArrayList<IVisitablePointable>();
    private ARecordType cachedReqType = null;
    private final ResettableByteArrayOutputStream bos = new ResettableByteArrayOutputStream();
    private final DataOutputStream dos = new DataOutputStream((OutputStream)((Object)this.bos));
    private final RecordBuilder recBuilder = new RecordBuilder();
    private final IVisitablePointable nullTypeTag = PointableAllocator.allocateUnrestableEmpty();
    private final IVisitablePointable missingTypeTag = PointableAllocator.allocateUnrestableEmpty();
    private final IBinaryComparator fieldNameComparator = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final ByteArrayAccessibleOutputStream outputBos = new ByteArrayAccessibleOutputStream();
    private final DataOutputStream outputDos = new DataOutputStream((OutputStream)this.outputBos);
    private final IVisitablePointable fieldTempReference = PointableAllocator.allocateUnrestableEmpty();
    private final Triple<IVisitablePointable, IAType, Boolean> nestedVisitorArg = new Triple((Object)this.fieldTempReference, null, null);
    private int numInputFields = 0;
    private int[] fieldPermutation;
    private boolean[] optionalFields;
    private boolean[] openFields;
    private int[] fieldNamesSortedIndex;
    private int[] reqFieldNamesSortedIndex;
    private final UTF8StringWriter utf8Writer = new UTF8StringWriter();

    public ARecordCaster() throws HyracksDataException {
        try {
            this.bos.reset();
            int start = this.bos.size();
            this.dos.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            int end = this.bos.size();
            this.missingTypeTag.set(this.bos.getByteArray(), start, end - start);
            start = this.bos.size();
            this.dos.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            end = this.bos.size();
            this.nullTypeTag.set(this.bos.getByteArray(), start, end - start);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void castRecord(ARecordVisitablePointable recordAccessor, IVisitablePointable resultAccessor, ARecordType reqType, ACastVisitor visitor) throws HyracksDataException {
        List<IVisitablePointable> fieldNames = recordAccessor.getFieldNames();
        List<IVisitablePointable> fieldTypeTags = recordAccessor.getFieldTypeTags();
        List<IVisitablePointable> fieldValues = recordAccessor.getFieldValues();
        this.numInputFields = fieldNames.size();
        if (this.openFields == null || this.numInputFields > this.openFields.length) {
            this.openFields = new boolean[this.numInputFields];
            this.fieldNamesSortedIndex = new int[this.numInputFields];
        }
        if (!reqType.equals(this.cachedReqType)) {
            try {
                this.loadRequiredType(reqType);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.reset();
        this.matchClosedPart(fieldNames, fieldTypeTags);
        this.writeOutput(fieldNames, fieldTypeTags, fieldValues, this.outputDos, visitor);
        resultAccessor.set(this.outputBos.getByteArray(), 0, this.outputBos.size());
    }

    private void reset() {
        int i;
        for (i = 0; i < this.numInputFields; ++i) {
            this.openFields[i] = true;
        }
        for (i = 0; i < this.fieldPermutation.length; ++i) {
            this.fieldPermutation[i] = -1;
        }
        for (i = 0; i < this.numInputFields; ++i) {
            this.fieldNamesSortedIndex[i] = i;
        }
        this.outputBos.reset();
    }

    private void loadRequiredType(ARecordType reqType) throws IOException {
        int i;
        this.reqFieldNames.clear();
        this.reqFieldTypeTags.clear();
        this.allocator.reset();
        this.cachedReqType = reqType;
        int numSchemaFields = reqType.getFieldTypes().length;
        IAType[] fieldTypes = reqType.getFieldTypes();
        String[] fieldNames = reqType.getFieldNames();
        this.fieldPermutation = new int[numSchemaFields];
        this.optionalFields = new boolean[numSchemaFields];
        for (i = 0; i < this.optionalFields.length; ++i) {
            this.optionalFields[i] = false;
        }
        this.bos.reset(this.nullTypeTag.getStartOffset() + this.nullTypeTag.getLength());
        for (i = 0; i < numSchemaFields; ++i) {
            ATypeTag ftypeTag = fieldTypes[i].getTypeTag();
            String fname = fieldNames[i];
            if (NonTaggedFormatUtil.isOptional(fieldTypes[i])) {
                ftypeTag = ((AUnionType)fieldTypes[i]).getActualType().getTypeTag();
                this.optionalFields[i] = true;
            }
            int tagStart = this.bos.size();
            this.dos.writeByte(ftypeTag.serialize());
            int tagEnd = this.bos.size();
            AFlatValuePointable typeTagPointable = this.allocator.allocateEmpty();
            typeTagPointable.set(this.bos.getByteArray(), tagStart, tagEnd - tagStart);
            this.reqFieldTypeTags.add(typeTagPointable);
            int nameStart = this.bos.size();
            this.dos.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.utf8Writer.writeUTF8((CharSequence)fname, (DataOutput)this.dos);
            int nameEnd = this.bos.size();
            AFlatValuePointable typeNamePointable = this.allocator.allocateEmpty();
            typeNamePointable.set(this.bos.getByteArray(), nameStart, nameEnd - nameStart);
            this.reqFieldNames.add(typeNamePointable);
        }
        this.reqFieldNamesSortedIndex = new int[this.reqFieldNames.size()];
        for (i = 0; i < this.reqFieldNamesSortedIndex.length; ++i) {
            this.reqFieldNamesSortedIndex[i] = i;
        }
        this.quickSort(this.reqFieldNamesSortedIndex, this.reqFieldNames, 0, this.reqFieldNamesSortedIndex.length - 1);
    }

    private void matchClosedPart(List<IVisitablePointable> fieldNames, List<IVisitablePointable> fieldTypeTags) throws HyracksDataException {
        int i;
        this.quickSort(this.fieldNamesSortedIndex, fieldNames, 0, this.numInputFields - 1);
        int fnStart = 0;
        int reqFnStart = 0;
        while (fnStart < this.numInputFields && reqFnStart < this.reqFieldNames.size()) {
            int fnPos = this.fieldNamesSortedIndex[fnStart];
            int reqFnPos = this.reqFieldNamesSortedIndex[reqFnStart];
            int c = this.compare((IValueReference)fieldNames.get(fnPos), (IValueReference)this.reqFieldNames.get(reqFnPos));
            if (c == 0) {
                IVisitablePointable reqFieldTypeTag;
                IVisitablePointable fieldTypeTag = fieldTypeTags.get(fnPos);
                if (fieldTypeTag.equals(reqFieldTypeTag = this.reqFieldTypeTags.get(reqFnPos)) || this.optionalFields[reqFnPos] && fieldTypeTag.equals(this.nullTypeTag) || fieldTypeTag.equals(this.missingTypeTag)) {
                    this.fieldPermutation[reqFnPos] = fnPos;
                    this.openFields[fnPos] = false;
                } else {
                    ATypeTag requiredTypeTag;
                    ATypeTag inputTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fieldTypeTag.getByteArray()[fieldTypeTag.getStartOffset()]);
                    if (ATypeHierarchy.canPromote(inputTypeTag, requiredTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(reqFieldTypeTag.getByteArray()[reqFieldTypeTag.getStartOffset()])) || ATypeHierarchy.canDemote(inputTypeTag, requiredTypeTag)) {
                        this.fieldPermutation[reqFnPos] = fnPos;
                        this.openFields[fnPos] = false;
                    } else {
                        throw new RuntimeDataException(1, new Serializable[]{inputTypeTag, requiredTypeTag});
                    }
                }
                ++fnStart;
                ++reqFnStart;
            }
            if (c > 0) {
                ++reqFnStart;
            }
            if (c >= 0) continue;
            ++fnStart;
        }
        for (i = 0; i < this.openFields.length; ++i) {
            if (!this.openFields[i] || this.cachedReqType.isOpen()) continue;
            IVisitablePointable fieldName = fieldNames.get(i);
            ByteArrayOutputStream fieldBos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(fieldBos);
            APrintVisitor printVisitor = new APrintVisitor();
            Pair visitorArg = new Pair((Object)ps, (Object)ATypeTag.STRING);
            fieldName.accept(printVisitor, visitorArg);
            ps.print(":");
            IVisitablePointable fieldType = fieldTypeTags.get(i);
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fieldType.getByteArray()[fieldType.getStartOffset()]);
            ps.print(typeTag);
            throw new HyracksDataException("type mismatch: including an extra field " + fieldBos.toString());
        }
        for (i = 0; i < this.fieldPermutation.length; ++i) {
            IAType t;
            if (this.fieldPermutation[i] >= 0 || NonTaggedFormatUtil.isOptional(t = this.cachedReqType.getFieldTypes()[i])) continue;
            throw new HyracksDataException("type mismatch: missing a required closed field " + this.cachedReqType.getFieldNames()[i] + ": " + t.getTypeName());
        }
    }

    private void writeOutput(List<IVisitablePointable> fieldNames, List<IVisitablePointable> fieldTypeTags, List<IVisitablePointable> fieldValues, DataOutput output, ACastVisitor visitor) throws HyracksDataException {
        IVisitablePointable field;
        int i;
        this.recBuilder.reset(this.cachedReqType);
        this.recBuilder.init();
        for (i = 0; i < this.fieldPermutation.length; ++i) {
            int pos = this.fieldPermutation[i];
            field = pos >= 0 ? fieldValues.get(pos) : this.missingTypeTag;
            IAType fType = this.cachedReqType.getFieldTypes()[i];
            this.nestedVisitorArg.second = fType;
            if (this.optionalFields[i]) {
                IVisitablePointable fieldTypeTag;
                IVisitablePointable iVisitablePointable = fieldTypeTag = pos >= 0 ? fieldTypeTags.get(pos) : null;
                this.nestedVisitorArg.second = fieldTypeTag == null || fieldTypeTag.equals(this.missingTypeTag) ? BuiltinType.AMISSING : (fieldTypeTag.equals(this.nullTypeTag) ? BuiltinType.ANULL : ((AUnionType)fType).getActualType());
            }
            field.accept(visitor, this.nestedVisitorArg);
            this.recBuilder.addField(i, (IValueReference)this.nestedVisitorArg.first);
        }
        for (i = 0; i < this.numInputFields; ++i) {
            if (!this.openFields[i]) continue;
            IVisitablePointable name = fieldNames.get(i);
            field = fieldValues.get(i);
            IVisitablePointable fieldTypeTag = fieldTypeTags.get(i);
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fieldTypeTag.getByteArray()[fieldTypeTag.getStartOffset()]);
            this.nestedVisitorArg.second = DefaultOpenFieldType.getDefaultOpenFieldType(typeTag);
            field.accept(visitor, this.nestedVisitorArg);
            this.recBuilder.addField((IValueReference)name, (IValueReference)this.nestedVisitorArg.first);
        }
        this.recBuilder.write(output, true);
    }

    private void quickSort(int[] index, List<IVisitablePointable> names, int start, int end) throws HyracksDataException {
        if (end <= start) {
            return;
        }
        int i = this.partition(index, names, start, end);
        this.quickSort(index, names, start, i - 1);
        this.quickSort(index, names, i + 1, end);
    }

    private int partition(int[] index, List<IVisitablePointable> names, int left, int right) throws HyracksDataException {
        int i = left - 1;
        int j = right;
        while (true) {
            if (this.compare((IValueReference)names.get(index[++i]), (IValueReference)names.get(index[right])) < 0) {
                continue;
            }
            while (this.compare((IValueReference)names.get(index[right]), (IValueReference)names.get(index[--j])) < 0 && j != left) {
            }
            if (i >= j) break;
            this.swap(index, i, j);
        }
        this.swap(index, i, right);
        return i;
    }

    private void swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    private int compare(IValueReference a, IValueReference b) throws HyracksDataException {
        return this.fieldNameComparator.compare(a.getByteArray(), a.getStartOffset() + 1, a.getLength() - 1, b.getByteArray(), b.getStartOffset() + 1, b.getLength() - 1);
    }
}

