/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;

public class FieldCursorForDelimitedDataParser {
    private static final String CLOSING_Q = "missing a closing quote";
    private static final String OPENING_Q = "a quote should be in the beginning";
    private static final String DELIMITER_AFTER_Q = "a quote enclosing a field needs to be followed by the delimiter";
    private final IWarningCollector warnings;
    private final Supplier<String> dataSourceName;
    private char[] buffer;
    private int fStart;
    private int fEnd;
    private long lineCount;
    private int fieldCount;
    private int doubleQuoteCount;
    private boolean isDoubleQuoteIncludedInThisField;
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final int INCREMENT = 4096;
    private final Reader in;
    private int start;
    private int end;
    private State state;
    private int lastQuotePosition;
    private int lastDoubleQuotePosition;
    private int lastDelimiterPosition;
    private int quoteCount;
    private boolean startedQuote;
    private final char quote;
    private final char fieldDelimiter;

    public FieldCursorForDelimitedDataParser(Reader in, char fieldDelimiter, char quote, IWarningCollector warningCollector, Supplier<String> dataSourceName) {
        this.warnings = warningCollector;
        this.dataSourceName = dataSourceName;
        this.in = in;
        if (in != null) {
            this.buffer = new char[4096];
            this.end = 0;
        } else {
            this.end = Integer.MAX_VALUE;
        }
        this.start = 0;
        this.state = State.INIT;
        this.quote = quote;
        this.fieldDelimiter = fieldDelimiter;
        this.lastDelimiterPosition = -1;
        this.lastQuotePosition = -1;
        this.lastDoubleQuotePosition = -1;
        this.quoteCount = 0;
        this.doubleQuoteCount = 0;
        this.startedQuote = false;
        this.isDoubleQuoteIncludedInThisField = false;
        this.lineCount = 1L;
        this.fieldCount = 0;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getFieldStart() {
        return this.fStart;
    }

    public int getFieldLength() {
        return this.fEnd - this.fStart;
    }

    public boolean isFieldEmpty() {
        return this.fStart == this.fEnd;
    }

    public boolean fieldHasDoubleQuote() {
        return this.isDoubleQuoteIncludedInThisField;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public void nextRecord(char[] buffer, int recordLength, long lineNumber) {
        this.lineCount = lineNumber;
        this.fieldCount = 0;
        this.lastDelimiterPosition = -1;
        this.lastQuotePosition = -1;
        this.lastDoubleQuotePosition = -1;
        this.quoteCount = 0;
        this.doubleQuoteCount = 0;
        this.startedQuote = false;
        this.isDoubleQuoteIncludedInThisField = false;
        this.start = 0;
        this.end = recordLength;
        this.state = State.IN_RECORD;
        this.buffer = buffer;
    }

    public boolean nextRecord() throws IOException {
        this.fieldCount = 0;
        while (true) {
            block0 : switch (this.state) {
                case INIT: {
                    boolean eof;
                    boolean bl = eof = !this.readMore();
                    if (eof) {
                        this.state = State.EOF;
                        return false;
                    }
                    this.state = State.IN_RECORD;
                    return true;
                }
                case IN_RECORD: {
                    char ch;
                    boolean eof;
                    int p = this.start;
                    char lastChar = '\u0000';
                    while (true) {
                        if (p >= this.end) {
                            int s = this.start;
                            boolean bl = eof = !this.readMore();
                            if (eof) {
                                this.state = State.EOF;
                                return this.start < this.end;
                            }
                            p -= s - this.start;
                            this.lastQuotePosition -= s - this.start;
                            this.lastDoubleQuotePosition -= s - this.start;
                            this.lastDelimiterPosition -= s - this.start;
                        }
                        if ((ch = this.buffer[p]) == this.quote) {
                            this.startedQuote = true;
                            if (this.lastQuotePosition == p - 1 && this.start != p - 1 && this.lastDoubleQuotePosition != p - 1) {
                                this.lastDoubleQuotePosition = p;
                            }
                            this.lastQuotePosition = p;
                        } else if (ch == this.fieldDelimiter) {
                            if (this.startedQuote && this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1) {
                                this.startedQuote = false;
                                this.lastDelimiterPosition = p;
                            }
                        } else {
                            if (ch == '\n' && !this.startedQuote) {
                                this.start = p + 1;
                                this.state = State.EOR;
                                this.lastDelimiterPosition = p;
                                break block0;
                            }
                            if (ch == '\r' && !this.startedQuote) {
                                this.start = p + 1;
                                this.state = State.CR;
                                this.lastDelimiterPosition = p;
                                break block0;
                            }
                        }
                        if (ch == '\r' || ch == '\n' && lastChar != '\r') {
                            ++this.lineCount;
                        }
                        lastChar = ch;
                        ++p;
                    }
                }
                case CR: {
                    char ch;
                    boolean eof;
                    if (this.start >= this.end) {
                        boolean bl = eof = !this.readMore();
                        if (eof) {
                            this.state = State.EOF;
                            return false;
                        }
                    }
                    if ((ch = this.buffer[this.start]) != '\n') {
                        ++this.lineCount;
                    }
                    if (ch == '\n' && !this.startedQuote) {
                        ++this.start;
                        this.state = State.EOR;
                    } else {
                        this.state = State.IN_RECORD;
                        return true;
                    }
                }
                case EOR: {
                    boolean eof;
                    ++this.lineCount;
                    if (this.start >= this.end) {
                        boolean bl = eof = !this.readMore();
                        if (eof) {
                            this.state = State.EOF;
                            return false;
                        }
                    }
                    this.state = State.IN_RECORD;
                    this.lastDelimiterPosition = this.start;
                    return this.start < this.end;
                }
                case EOF: {
                    return false;
                }
                case FAILED: {
                    return false;
                }
            }
        }
    }

    public Result nextField() throws IOException {
        switch (this.state) {
            case INIT: 
            case CR: 
            case EOR: 
            case EOF: {
                return Result.END;
            }
            case FAILED: {
                return Result.ERROR;
            }
            case IN_RECORD: {
                ++this.fieldCount;
                this.startedQuote = false;
                this.isDoubleQuoteIncludedInThisField = false;
                this.lastQuotePosition = -1;
                this.lastDoubleQuotePosition = -1;
                this.quoteCount = 0;
                this.doubleQuoteCount = 0;
                char lastChar = '\u0000';
                int p = this.start;
                while (true) {
                    char ch;
                    if (p >= this.end) {
                        int s = this.start;
                        boolean eof = !this.readMore();
                        p -= s - this.start;
                        this.lastQuotePosition -= this.lastQuotePosition > -1 ? s - this.start : 0;
                        this.lastDoubleQuotePosition -= this.lastDoubleQuotePosition > -1 ? s - this.start : 0;
                        this.lastDelimiterPosition -= this.lastDelimiterPosition > -1 ? s - this.start : 0;
                        if (eof) {
                            this.state = State.EOF;
                            if (!this.startedQuote) {
                                this.fStart = this.start;
                                this.fEnd = p;
                            } else if (this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                                this.fStart = this.start + 1;
                                this.fEnd = p - 1;
                            } else {
                                this.state = State.FAILED;
                                if (this.warnings.shouldWarn()) {
                                    this.warn(CLOSING_Q);
                                }
                                return Result.ERROR;
                            }
                            return Result.OK;
                        }
                    }
                    if ((ch = this.buffer[p]) == this.quote) {
                        if (!this.startedQuote) {
                            if (p == this.start) {
                                this.startedQuote = true;
                            } else {
                                this.state = State.FAILED;
                                if (this.warnings.shouldWarn()) {
                                    this.warn(OPENING_Q);
                                }
                                return Result.ERROR;
                            }
                        }
                        if (this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.lastQuotePosition != this.start) {
                            this.isDoubleQuoteIncludedInThisField = true;
                            ++this.doubleQuoteCount;
                            this.lastDoubleQuotePosition = p;
                        }
                        this.lastQuotePosition = p;
                        ++this.quoteCount;
                    } else if (ch == this.fieldDelimiter) {
                        if (!this.startedQuote) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.lastDelimiterPosition = p;
                            return Result.OK;
                        }
                        if (this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.lastQuotePosition != this.start) {
                            this.fStart = this.start + 1;
                            this.fEnd = p - 1;
                            this.start = p + 1;
                            this.lastDelimiterPosition = p;
                            this.startedQuote = false;
                            return Result.OK;
                        }
                        if (this.lastQuotePosition < p - 1 && this.lastQuotePosition != this.lastDoubleQuotePosition && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                            this.state = State.FAILED;
                            if (this.warnings.shouldWarn()) {
                                this.warn(DELIMITER_AFTER_Q);
                            }
                            return Result.ERROR;
                        }
                    } else if (ch == '\n' || ch == '\r') {
                        if (!this.startedQuote) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.state = ch == '\n' ? State.EOR : State.CR;
                            this.lastDelimiterPosition = p;
                            return Result.OK;
                        }
                        if (this.lastQuotePosition == p - 1 && this.lastDoubleQuotePosition != p - 1 && this.quoteCount == this.doubleQuoteCount * 2 + 2) {
                            this.fStart = this.start + 1;
                            this.fEnd = p - 1;
                            this.lastDelimiterPosition = p;
                            this.start = p + 1;
                            this.state = ch == '\n' ? State.EOR : State.CR;
                            this.startedQuote = false;
                            return Result.OK;
                        }
                    }
                    if (ch == '\r' || ch == '\n' && lastChar != '\r') {
                        ++this.lineCount;
                    }
                    lastChar = ch;
                    ++p;
                }
            }
        }
        throw new IllegalStateException();
    }

    private boolean readMore() throws IOException {
        int n;
        if (this.in == null) {
            return false;
        }
        if (this.start > 0) {
            System.arraycopy(this.buffer, this.start, this.buffer, 0, this.end - this.start);
        }
        this.end -= this.start;
        this.start = 0;
        if (this.end == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + 4096);
        }
        if ((n = this.in.read(this.buffer, this.end, this.buffer.length - this.end)) < 0) {
            return false;
        }
        this.end += n;
        return true;
    }

    public void eliminateDoubleQuote() {
        int lastDoubleQuotePosition = -1;
        int writepos = this.fStart;
        int readpos = this.fStart;
        int length = this.fEnd - this.fStart;
        for (int i = 0; i < length; ++i) {
            if (this.buffer[readpos] == this.quote && lastDoubleQuotePosition != readpos - 1) {
                lastDoubleQuotePosition = readpos++;
                continue;
            }
            if (writepos != readpos) {
                this.buffer[writepos] = this.buffer[readpos];
            }
            ++writepos;
            ++readpos;
        }
        this.fEnd -= this.doubleQuoteCount;
        this.isDoubleQuoteIncludedInThisField = false;
    }

    private void warn(String message) {
        this.warnings.warn(Warning.forHyracks(null, (int)124, (Serializable[])new Serializable[]{(Serializable)((Object)this.dataSourceName.get()), Long.valueOf(this.lineCount), Integer.valueOf(this.fieldCount), message}));
    }

    public static enum Result {
        OK,
        ERROR,
        END;

    }

    private static enum State {
        INIT,
        IN_RECORD,
        EOR,
        CR,
        EOF,
        FAILED;

    }
}

