/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.AbstractSqlppExpressionExtractionVisitor;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;

public final class SqlppCaseAggregateExtractionVisitor
extends AbstractSqlppExpressionExtractionVisitor {
    public SqlppCaseAggregateExtractionVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    protected void visitLetWhereClauses(List<AbstractClause> letWhereList, ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList) {
    }

    @Override
    protected void visitGroupByClause(GroupbyClause groupbyClause, ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList, List<AbstractClause> letWhereList) {
    }

    @Override
    public Expression visit(CaseExpression caseExpr, ILangExpression arg) throws CompilationException {
        Expression resultExpr = super.visit(caseExpr, arg);
        resultExpr.accept((ILangVisitor)new Sql92AggregateExtractionVisitor(), (Object)arg);
        return resultExpr;
    }

    @Override
    public Expression visit(IfExpr ifExpr, ILangExpression arg) throws CompilationException {
        Expression resultExpr = super.visit(ifExpr, arg);
        resultExpr.accept((ILangVisitor)new Sql92AggregateExtractionVisitor(), (Object)arg);
        return resultExpr;
    }

    @Override
    void handleUnsupportedClause(FromClause clause) throws CompilationException {
        throw new CompilationException(1103, clause.getSourceLocation(), new Serializable[]{BuiltinFunctions.SWITCH_CASE.getName()});
    }

    private final class Sql92AggregateExtractionVisitor
    extends AbstractSqlppSimpleExpressionVisitor {
        private Sql92AggregateExtractionVisitor() {
        }

        @Override
        public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
            AbstractSqlppExpressionExtractionVisitor.StackElement stackElement;
            CallExpr resultExpr = (CallExpr)super.visit(callExpr, arg);
            if (FunctionMapUtil.isSql92AggregateFunction(resultExpr.getFunctionSignature()) && (stackElement = (AbstractSqlppExpressionExtractionVisitor.StackElement)SqlppCaseAggregateExtractionVisitor.this.stack.peek()) != null && stackElement.getSelectBlock().hasGroupbyClause()) {
                VarIdentifier v = stackElement.addPendingLetClause((Expression)resultExpr);
                VariableExpr vExpr = new VariableExpr(v);
                vExpr.setSourceLocation(callExpr.getSourceLocation());
                return vExpr;
            }
            return resultExpr;
        }

        @Override
        public Expression visit(SelectExpression selectExpression, ILangExpression arg) {
            return selectExpression;
        }
    }
}

