/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushLimitIntoOrderByRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (context.checkAndAddToAlreadyCompared((ILogicalOperator)op, (ILogicalOperator)op2)) {
            return false;
        }
        if (op2.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        boolean res = this.pushLimitIntoOrder(opRef, (Mutable<ILogicalOperator>)opRef2, context);
        if (res) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return res;
    }

    private boolean pushLimitIntoOrder(Mutable<ILogicalOperator> opRef, Mutable<ILogicalOperator> opRef2, IOptimizationContext context) throws AlgebricksException {
        LimitOperator limitOp = (LimitOperator)opRef.getValue();
        OrderOperator orderOp = (OrderOperator)opRef2.getValue();
        if (orderOp.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.STABLE_SORT) {
            return false;
        }
        Integer topK = PushLimitIntoOrderByRule.getOutputLimit(limitOp);
        if (topK == null) {
            return false;
        }
        OrderOperator newOrderOp = new OrderOperator(orderOp.getOrderExpressions(), topK.intValue());
        newOrderOp.setSourceLocation(orderOp.getSourceLocation());
        newOrderOp.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(newOrderOp.getTopK()));
        newOrderOp.getInputs().addAll(orderOp.getInputs());
        newOrderOp.setExecutionMode(orderOp.getExecutionMode());
        newOrderOp.recomputeSchema();
        newOrderOp.computeDeliveredPhysicalProperties(context);
        opRef2.setValue((Object)newOrderOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newOrderOp);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)limitOp);
        return true;
    }

    static Integer getOutputLimit(LimitOperator limitOp) {
        ILogicalExpression offsetExpr;
        ILogicalExpression maxObjectsExpr = (ILogicalExpression)limitOp.getMaxObjects().getValue();
        IAObject maxObjectsValue = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)maxObjectsExpr, (ATypeTag)ATypeTag.INTEGER);
        if (maxObjectsValue == null) {
            return null;
        }
        int topK = ((AInt32)maxObjectsValue).getIntegerValue();
        if (topK < 0) {
            topK = 0;
        }
        if ((offsetExpr = (ILogicalExpression)limitOp.getOffset().getValue()) != null) {
            IAObject offsetValue = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)offsetExpr, (ATypeTag)ATypeTag.INTEGER);
            if (offsetValue == null) {
                return null;
            }
            int offset = ((AInt32)offsetValue).getIntegerValue();
            if (offset < 0) {
                offset = 0;
            }
            if (offset >= Integer.MAX_VALUE - topK) {
                return null;
            }
            topK += offset;
        }
        return topK;
    }
}

