/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.LinkedList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class EliminateSubplanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op;
        Mutable outerRef = (Mutable)subplan.getInputs().get(0);
        AbstractLogicalOperator outerRefOp = (AbstractLogicalOperator)outerRef.getValue();
        if (outerRefOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            this.elimSubplanOverEts(opRef, context);
            return true;
        }
        return subplan.getNestedPlans().size() == 1 && ((ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots().size() == 1 && !OperatorPropertiesUtil.hasFreeVariables((ILogicalOperator)subplan) && this.elimOneSubplanWithNoFreeVars(opRef);
    }

    private boolean elimOneSubplanWithNoFreeVars(Mutable<ILogicalOperator> opRef) {
        SubplanOperator subplan = (SubplanOperator)opRef.getValue();
        AbstractLogicalOperator rootOp = (AbstractLogicalOperator)((Mutable)((ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        if (rootOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE || rootOp.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            opRef.setValue(((Mutable)subplan.getInputs().get(0)).getValue());
            return true;
        }
        AbstractLogicalOperator botOp = rootOp;
        if (botOp.getInputs().size() != 1) {
            return false;
        }
        do {
            Mutable botRef;
            if ((botOp = (AbstractLogicalOperator)(botRef = (Mutable)botOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) continue;
            botRef.setValue(((Mutable)subplan.getInputs().get(0)).getValue());
            opRef.setValue((Object)rootOp);
            return true;
        } while (botOp.getInputs().size() == 1);
        return false;
    }

    private void elimSubplanOverEts(Mutable<ILogicalOperator> opRef, IOptimizationContext ctx) throws AlgebricksException {
        SubplanOperator subplan = (SubplanOperator)opRef.getValue();
        SourceLocation sourceLoc = subplan.getSourceLocation();
        for (ILogicalPlan p : subplan.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                OperatorManipulationUtil.ntsToEts((Mutable)r, (IOptimizationContext)ctx);
            }
        }
        LinkedList allRoots = subplan.allRootsInReverseOrder();
        if (allRoots.size() == 1) {
            opRef.setValue(((Mutable)allRoots.get(0)).getValue());
        } else {
            ILogicalOperator topOp = null;
            for (Mutable r : allRoots) {
                if (topOp == null) {
                    topOp = (ILogicalOperator)r.getValue();
                    continue;
                }
                InnerJoinOperator j = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
                j.setSourceLocation(sourceLoc);
                j.getInputs().add(new MutableObject((Object)topOp));
                j.getInputs().add(r);
                ctx.setOutputTypeEnvironment((ILogicalOperator)j, j.computeOutputTypeEnvironment((ITypingContext)ctx));
                topOp = j;
            }
            opRef.setValue(topOp);
        }
    }
}

