/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class QueueAclsInfo
implements Writable {
    private String queueName;
    private String[] operations;

    public QueueAclsInfo() {
    }

    public QueueAclsInfo(String queueName, String[] operations) {
        this.queueName = queueName;
        this.operations = operations;
    }

    public String getQueueName() {
        return this.queueName;
    }

    protected void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String[] getOperations() {
        return this.operations;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.queueName = StringInterner.weakIntern(Text.readString(in));
        this.operations = WritableUtils.readStringArray(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.queueName);
        WritableUtils.writeStringArray(out, this.operations);
    }
}

