/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.collect.ImmutableMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CassandraTopologyMonitor;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CassandraTopologyMonitorTest {
    CassandraTopologyMonitorTest() {
    }

    @Test
    void testNoTopologyChange() {
        ClusterInfo mockClusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)mockClusterInfo.getTokenRangeMapping(false)).thenReturn(this.buildTopology(10));
        AtomicBoolean noChange = new AtomicBoolean(true);
        CassandraTopologyMonitor monitor = new CassandraTopologyMonitor(mockClusterInfo, event -> noChange.set(false));
        monitor.checkTopologyOnDemand();
        Assertions.assertThat((boolean)noChange.get()).isTrue();
    }

    @Test
    void testTopologyChanged() {
        ClusterInfo mockClusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)mockClusterInfo.getTokenRangeMapping(false)).thenReturn(this.buildTopology(10)).thenReturn(this.buildTopology(11));
        AtomicBoolean noChange = new AtomicBoolean(true);
        CassandraTopologyMonitor monitor = new CassandraTopologyMonitor(mockClusterInfo, event -> noChange.set(false));
        monitor.checkTopologyOnDemand();
        Assertions.assertThat((boolean)noChange.get()).isFalse();
    }

    private TokenRangeMapping<RingInstance> buildTopology(int instancesCount) {
        return TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), instancesCount);
    }
}

