/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.airline.Context;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;

public class ParseState {
    private final List<Context> locationStack;
    private final CommandGroupMetadata group;
    private final CommandMetadata command;
    private final ListMultimap<OptionMetadata, Object> parsedOptions;
    private final List<Object> parsedArguments;
    private final OptionMetadata currentOption;
    private final List<String> unparsedInput;

    ParseState(CommandGroupMetadata group, CommandMetadata command, ListMultimap<OptionMetadata, Object> parsedOptions, List<Context> locationStack, List<Object> parsedArguments, OptionMetadata currentOption, List<String> unparsedInput) {
        this.group = group;
        this.command = command;
        this.parsedOptions = parsedOptions;
        this.locationStack = locationStack;
        this.parsedArguments = parsedArguments;
        this.currentOption = currentOption;
        this.unparsedInput = unparsedInput;
    }

    public static ParseState newInstance() {
        return new ParseState(null, null, ArrayListMultimap.create(), ImmutableList.of(), ImmutableList.of(), null, ImmutableList.of());
    }

    public ParseState pushContext(Context location) {
        ImmutableCollection locationStack = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.locationStack)).add((Object)location)).build();
        return new ParseState(this.group, this.command, this.parsedOptions, (List<Context>)((Object)locationStack), this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState popContext() {
        ImmutableList<Context> locationStack = ImmutableList.copyOf(this.locationStack.subList(0, this.locationStack.size() - 1));
        return new ParseState(this.group, this.command, this.parsedOptions, locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withOptionValue(OptionMetadata option, Object value) {
        ImmutableMultimap newOptions = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll(this.parsedOptions)).put(option, value)).build();
        return new ParseState(this.group, this.command, (ListMultimap<OptionMetadata, Object>)((Object)newOptions), this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withGroup(CommandGroupMetadata group) {
        return new ParseState(group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withCommand(CommandMetadata command) {
        return new ParseState(this.group, command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withOption(OptionMetadata option) {
        return new ParseState(this.group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, option, this.unparsedInput);
    }

    public ParseState withArgument(Object argument) {
        ImmutableCollection newArguments = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parsedArguments)).add(argument)).build();
        return new ParseState(this.group, this.command, this.parsedOptions, this.locationStack, (List<Object>)((Object)newArguments), this.currentOption, this.unparsedInput);
    }

    public ParseState withUnparsedInput(String input) {
        ImmutableCollection newUnparsedInput = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.unparsedInput)).add(input)).build();
        return new ParseState(this.group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, (List<String>)((Object)newUnparsedInput));
    }

    public String toString() {
        return "ParseState{locationStack=" + this.locationStack + ", group=" + this.group + ", command=" + this.command + ", parsedOptions=" + this.parsedOptions + ", parsedArguments=" + this.parsedArguments + ", currentOption=" + this.currentOption + ", unparsedInput=" + this.unparsedInput + '}';
    }

    public Context getLocation() {
        return this.locationStack.get(this.locationStack.size() - 1);
    }

    public CommandGroupMetadata getGroup() {
        return this.group;
    }

    public CommandMetadata getCommand() {
        return this.command;
    }

    public OptionMetadata getCurrentOption() {
        return this.currentOption;
    }

    public ListMultimap<OptionMetadata, Object> getParsedOptions() {
        return this.parsedOptions;
    }

    public List<Object> getParsedArguments() {
        return this.parsedArguments;
    }

    public List<String> getUnparsedInput() {
        return this.unparsedInput;
    }
}

