/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.primitives.Longs;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutorPlus;
import org.apache.cassandra.concurrent.TaskFactory;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.RunnableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledThreadPoolExecutorPlus
extends ScheduledThreadPoolExecutor
implements ScheduledExecutorPlus {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledThreadPoolExecutorPlus.class);
    private static final TaskFactory taskFactory = TaskFactory.standard();
    public static final RejectedExecutionHandler rejectedExecutionHandler = (task, executor) -> {
        if (executor.isShutdown()) {
            if (!StorageService.instance.isShutdown()) {
                throw new RejectedExecutionException("ScheduledThreadPoolExecutor has shut down.");
            }
            if (task instanceof java.util.concurrent.Future) {
                ((java.util.concurrent.Future)((Object)task)).cancel(false);
            }
        } else {
            throw new AssertionError((Object)"Unknown rejection of ScheduledThreadPoolExecutor task");
        }
        logger.debug("ScheduledThreadPoolExecutor has shut down as part of C* shutdown");
    };

    ScheduledThreadPoolExecutorPlus(NamedThreadFactory threadFactory) {
        super(1, threadFactory);
        this.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return super.schedule(ExecutionFailure.propagating(task), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return super.schedule(ExecutionFailure.propagating(task), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(ExecutionFailure.suppressing(task), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(ExecutionFailure.suppressing(task), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleSelfRecurring(Runnable run, long delay, TimeUnit units) {
        return this.schedule(run, delay, units);
    }

    @Override
    public ScheduledFuture<?> scheduleAt(Runnable run, long deadline) {
        return this.schedule(run, Longs.max(0L, deadline - Clock.Global.nanoTime()), TimeUnit.NANOSECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleTimeoutAt(Runnable run, long deadline) {
        return this.scheduleTimeoutWithDelay(run, Longs.max(0L, deadline - Clock.Global.nanoTime()), TimeUnit.NANOSECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleTimeoutWithDelay(Runnable run, long delay, TimeUnit units) {
        return this.schedule(run, delay, units);
    }

    private <T extends Runnable> T addTask(T task) {
        super.execute(task);
        return task;
    }

    @Override
    public void execute(Runnable run) {
        this.addTask(taskFactory.toExecute(run));
    }

    @Override
    public void execute(WithResources withResources, Runnable run) {
        this.addTask(taskFactory.toExecute(withResources, run));
    }

    @Override
    public Future<?> submit(Runnable run) {
        return this.addTask(taskFactory.toSubmit(run));
    }

    @Override
    public <T> Future<T> submit(Runnable run, T result) {
        return this.addTask(taskFactory.toSubmit(run, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> call) {
        return this.addTask(taskFactory.toSubmit(call));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Runnable run, T result) {
        return this.addTask(taskFactory.toSubmit(withResources, run, result));
    }

    @Override
    public Future<?> submit(WithResources withResources, Runnable run) {
        return this.addTask(taskFactory.toSubmit(withResources, run));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Callable<T> call) {
        return this.addTask(taskFactory.toSubmit(withResources, call));
    }

    @Override
    public boolean inExecutor() {
        return Thread.currentThread().getThreadGroup() == this.getThreadFactory().threadGroup;
    }

    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return taskFactory.toSubmit(runnable, value);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return taskFactory.toSubmit(callable);
    }

    @Override
    public NamedThreadFactory getThreadFactory() {
        return (NamedThreadFactory)super.getThreadFactory();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> cancelled = super.shutdownNow();
        for (Runnable c : cancelled) {
            if (!(c instanceof java.util.concurrent.Future)) continue;
            ((java.util.concurrent.Future)((Object)c)).cancel(true);
        }
        return cancelled;
    }

    @Override
    protected void terminated() {
        this.getThreadFactory().close();
    }

    @Override
    public int getActiveTaskCount() {
        return this.getActiveCount();
    }

    @Override
    public int getPendingTaskCount() {
        return this.getQueue().size();
    }

    @Override
    public int getCorePoolSize() {
        return 1;
    }

    @Override
    public void setCorePoolSize(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaximumPoolSize() {
        return 1;
    }

    @Override
    public void setMaximumPoolSize(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxTasksQueued() {
        return Integer.MAX_VALUE;
    }
}

