/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.masking.ColumnMask;
import org.apache.cassandra.cql3.selection.ColumnTimestamps;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class SimpleSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            ByteBuffer columnName = ByteBufferUtil.readWithVIntLength(in);
            ColumnMetadata column = metadata.getColumn(columnName);
            int idx = in.readInt();
            return new SimpleSelector(column, idx, false, ProtocolVersion.CURRENT);
        }
    };
    public final ColumnMetadata column;
    private final int idx;
    private final ColumnMask.Masker masker;
    private ByteBuffer current;
    private ColumnTimestamps writetimes;
    private ColumnTimestamps ttls;
    private boolean isSet;

    public static Selector.Factory newFactory(ColumnMetadata def, int idx, boolean useForPostOrdering) {
        return new SimpleSelectorFactory(idx, def, useForPostOrdering);
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        builder.add(this.column);
    }

    @Override
    public void addInput(Selector.InputRow input) throws InvalidRequestException {
        if (!this.isSet) {
            this.isSet = true;
            this.writetimes = input.getWritetimes(this.idx);
            this.ttls = input.getTtls(this.idx);
            ByteBuffer value = input.getValue(this.idx);
            this.current = this.masker == null || input.unmask() || !DatabaseDescriptor.getDynamicDataMaskingEnabled() ? value : this.masker.mask(value);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        return this.current;
    }

    @Override
    protected ColumnTimestamps getWritetimes(ProtocolVersion protocolVersion) {
        return this.writetimes;
    }

    @Override
    protected ColumnTimestamps getTTLs(ProtocolVersion protocolVersion) {
        return this.ttls;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.current = null;
        this.writetimes = null;
        this.ttls = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.column.type;
    }

    public String toString() {
        return this.column.name.toString();
    }

    private SimpleSelector(ColumnMetadata column, int idx, boolean useForPostOrdering, ProtocolVersion version) {
        super(Selector.Kind.SIMPLE_SELECTOR);
        this.column = column;
        this.idx = idx;
        this.masker = useForPostOrdering || column.getMask() == null ? null : column.getMask().masker(version);
    }

    @Override
    public void validateForGroupBy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleSelector)) {
            return false;
        }
        SimpleSelector s2 = (SimpleSelector)o;
        return Objects.equal(this.column, s2.column) && Objects.equal(this.idx, s2.idx);
    }

    public int hashCode() {
        return Objects.hashCode(this.column, this.idx);
    }

    @Override
    protected int serializedSize(int version) {
        return ByteBufferUtil.serializedSizeWithVIntLength(this.column.name.bytes) + TypeSizes.sizeof(this.idx);
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        ByteBufferUtil.writeWithVIntLength(this.column.name.bytes, out);
        out.writeInt(this.idx);
    }

    public static final class SimpleSelectorFactory
    extends Selector.Factory {
        private final int idx;
        private final ColumnMetadata column;
        private final boolean useForPostOrdering;

        private SimpleSelectorFactory(int idx, ColumnMetadata def, boolean useForPostOrdering) {
            this.idx = idx;
            this.column = def;
            this.useForPostOrdering = useForPostOrdering;
        }

        @Override
        protected String getColumnName() {
            return this.column.name.toString();
        }

        @Override
        protected AbstractType<?> getReturnType() {
            return this.column.type;
        }

        @Override
        protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultColumn) {
            mapping.addMapping(resultColumn, this.column);
        }

        @Override
        public Selector newInstance(QueryOptions options) {
            return new SimpleSelector(this.column, this.idx, this.useForPostOrdering, options.getProtocolVersion());
        }

        @Override
        public boolean isSimpleSelectorFactory() {
            return true;
        }

        @Override
        public boolean isSimpleSelectorFactoryFor(int index) {
            return index == this.idx;
        }

        @Override
        public boolean areAllFetchedColumnsKnown() {
            return true;
        }

        @Override
        public void addFetchedColumns(ColumnFilter.Builder builder) {
            builder.add(this.column);
        }

        public ColumnMetadata getColumn() {
            return this.column;
        }
    }
}

