/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.StorageHook;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorWithLowerBound;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;

public class SinglePartitionReadCommand
extends ReadCommand
implements SinglePartitionReadQuery {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    protected final DecoratedKey partitionKey;
    protected final ClusteringIndexFilter clusteringIndexFilter;

    @VisibleForTesting
    protected SinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, Index.QueryPlan indexQueryPlan, boolean trackWarnings, DataRange dataRange) {
        super(ReadCommand.Kind.SINGLE_PARTITION, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, indexQueryPlan, trackWarnings, dataRange);
        assert (partitionKey.getPartitioner() == metadata.partitioner);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    private static SinglePartitionReadCommand create(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, Index.QueryPlan indexQueryPlan, boolean trackWarnings) {
        DataRange dataRange = new DataRange(new Bounds<PartitionPosition>(partitionKey, partitionKey), clusteringIndexFilter);
        if (metadata.isVirtual()) {
            return new VirtualTableSinglePartitionReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexQueryPlan, trackWarnings, dataRange);
        }
        return new SinglePartitionReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexQueryPlan, trackWarnings, dataRange);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, Index.QueryPlan indexQueryPlan) {
        return SinglePartitionReadCommand.create(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexQueryPlan, false);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, SinglePartitionReadCommand.findIndexQueryPlan(metadata, rowFilter));
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, RowFilter.none(), DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand fullPartitionRead(TableMetadata metadata, long nowInSec, DecoratedKey key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.ALL);
    }

    public static SinglePartitionReadCommand fullPartitionRead(TableMetadata metadata, long nowInSec, ByteBuffer key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.partitioner.decorateKey(key), Slices.ALL);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, DecoratedKey key, Slice slice) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.with(metadata.comparator, slice));
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, DecoratedKey key, Slices slices) {
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.none(), DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, ByteBuffer key, Slices slices) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.partitioner.decorateKey(key), slices);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, DecoratedKey key, NavigableSet<Clustering<?>> names) {
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(names, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.none(), DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, long nowInSec, DecoratedKey key, Clustering<?> name) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, FBUtilities.singleton(name, metadata.comparator));
    }

    @Override
    public SinglePartitionReadCommand copy() {
        return SinglePartitionReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    protected SinglePartitionReadCommand copyAsDigestQuery() {
        return SinglePartitionReadCommand.create(true, this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    protected SinglePartitionReadCommand copyAsTransientQuery() {
        return SinglePartitionReadCommand.create(false, 0, true, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public SinglePartitionReadCommand withUpdatedLimit(DataLimits newLimits) {
        return SinglePartitionReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.partitionKey(), this.clusteringIndexFilter(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getReadRpcTimeout(unit);
    }

    @Override
    public boolean isReversed() {
        return this.clusteringIndexFilter.isReversed();
    }

    @Override
    public SinglePartitionReadCommand forPaging(Clustering<?> lastReturned, DataLimits limits) {
        assert (!this.isDigestQuery());
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), limits, this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter() : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
        if (this.isTrackingWarnings()) {
            cmd.trackWarnings();
        }
        return cmd;
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
        if (this.clusteringIndexFilter.isEmpty(this.metadata().comparator)) {
            return EmptyIterators.partition();
        }
        return StorageProxy.read(Group.one(this), consistency, requestTime);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.readLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        UnfilteredRowIterator partition = cfs.isRowCacheEnabled() && !executionController.isTrackingRepairedStatus() ? this.getThroughCache(cfs, executionController) : this.queryMemtableAndDisk(cfs, executionController);
        return new SingletonUnfilteredPartitionIterator(partition);
    }

    private UnfilteredRowIterator getThroughCache(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        boolean cacheFullPartitions;
        assert (!cfs.isIndex());
        assert (cfs.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [%s]", cfs.name);
        RowCacheKey key = new RowCacheKey(this.metadata(), this.partitionKey());
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                cfs.metric.rowCacheMiss.inc();
                return this.queryMemtableAndDisk(cfs, executionController);
            }
            CachedPartition cachedPartition = (CachedPartition)cached;
            if (cfs.isFilterFullyCoveredBy(this.clusteringIndexFilter(), this.limits(), cachedPartition, this.nowInSec(), this.metadata().enforceStrictLiveness())) {
                cfs.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                UnfilteredRowIterator unfilteredRowIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), cachedPartition);
                cfs.metric.updateSSTableIterated(0);
                return unfilteredRowIterator;
            }
            cfs.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.queryMemtableAndDisk(cfs, executionController);
        }
        cfs.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        boolean bl = cacheFullPartitions = this.metadata().clusteringColumns().size() > 0 ? this.metadata().params.caching.cacheAllRows() : this.metadata().params.caching.cacheRows();
        if (cacheFullPartitions || this.clusteringIndexFilter().isHeadFilter()) {
            RowCacheSentinel sentinel = new RowCacheSentinel();
            boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
            boolean sentinelReplaced = false;
            try {
                UnfilteredRowIterator cacheIterator;
                UnfilteredRowIterator iter2;
                block16: {
                    final int rowsToCache = this.metadata().params.caching.rowsPerPartitionToCache();
                    final boolean enforceStrictLiveness = this.metadata().enforceStrictLiveness();
                    iter2 = SinglePartitionReadCommand.fullPartitionRead(this.metadata(), this.nowInSec(), this.partitionKey()).queryMemtableAndDisk(cfs, executionController);
                    try {
                        WrappingUnfilteredRowIterator toCacheIterator = new WrappingUnfilteredRowIterator(){
                            private int rowsCounted = 0;

                            @Override
                            public UnfilteredRowIterator wrapped() {
                                return iter2;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.rowsCounted < rowsToCache && iter2.hasNext();
                            }

                            @Override
                            public Unfiltered next() {
                                Row row;
                                Unfiltered unfiltered = (Unfiltered)iter2.next();
                                if (unfiltered.isRow() && (row = (Row)unfiltered).hasLiveData(SinglePartitionReadCommand.this.nowInSec(), enforceStrictLiveness)) {
                                    ++this.rowsCounted;
                                }
                                return unfiltered;
                            }
                        };
                        CachedBTreePartition toCache = CachedBTreePartition.create((UnfilteredRowIterator)toCacheIterator, this.nowInSec());
                        if (sentinelSuccess && !toCache.isEmpty()) {
                            Tracing.trace("Caching {} rows", (Object)toCache.rowCount());
                            CacheService.instance.rowCache.replace(key, sentinel, toCache);
                            sentinelReplaced = true;
                        }
                        cacheIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), toCache);
                        if (!cacheFullPartitions) break block16;
                        assert (!iter2.hasNext());
                        iter2.close();
                        UnfilteredRowIterator unfilteredRowIterator = cacheIterator;
                        return unfilteredRowIterator;
                    }
                    catch (Error | RuntimeException e) {
                        iter2.close();
                        throw e;
                    }
                }
                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.concat(cacheIterator, this.clusteringIndexFilter().filterNotIndexed(this.columnFilter(), iter2));
                return unfilteredRowIterator;
            }
            finally {
                if (sentinelSuccess && !sentinelReplaced) {
                    cfs.invalidateCachedPartition(key);
                }
            }
        }
        Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
        return this.queryMemtableAndDisk(cfs, executionController);
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        assert (executionController != null && executionController.validForReadOn(cfs));
        Tracing.trace("Executing single-partition query on {}", (Object)cfs.name);
        return this.queryMemtableAndDiskInternal(cfs, executionController);
    }

    private UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs, ReadExecutionController controller) {
        if (this.clusteringIndexFilter() instanceof ClusteringIndexNamesFilter && !this.metadata().isCounter() && !this.queriesMulticellType() && !controller.isTrackingRepairedStatus()) {
            return this.queryMemtableAndSSTablesInTimestampOrder(cfs, (ClusteringIndexNamesFilter)this.clusteringIndexFilter(), controller);
        }
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        view.sstables.sort(SSTableReader.maxTimestampDescending);
        ClusteringIndexFilter filter = this.clusteringIndexFilter();
        long minTimestamp = Long.MAX_VALUE;
        long mostRecentPartitionTombstone = Long.MIN_VALUE;
        ReadCommand.InputCollector<UnfilteredRowIterator> inputCollector = this.iteratorsForPartition(view, controller);
        try {
            SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
            for (Memtable memtable : view.memtables) {
                UnfilteredRowIterator iter2 = memtable.rowIterator(this.partitionKey(), filter.getSlices(this.metadata()), this.columnFilter(), filter.isReversed(), metricsCollector);
                if (iter2 == null) continue;
                if (memtable.getMinTimestamp() != -1L) {
                    minTimestamp = Math.min(minTimestamp, memtable.getMinTimestamp());
                }
                controller.updateMinOldestUnrepairedTombstone(memtable.getMinLocalDeletionTime());
                inputCollector.addMemtableIterator(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.MEMTABLE, false));
                mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter2.partitionLevelDeletion().markedForDeleteAt());
            }
            view.sstables.sort(SSTableReader.maxTimestampDescending);
            int nonIntersectingSSTables = 0;
            int includedDueToTombstones = 0;
            if (controller.isTrackingRepairedStatus()) {
                Tracing.trace("Collecting data from sstables and tracking repaired status");
            }
            for (SSTableReader sstable : view.sstables) {
                UnfilteredRowIterator iter3;
                if (sstable.getMaxTimestamp() < mostRecentPartitionTombstone) {
                    inputCollector.markInconclusive();
                    break;
                }
                boolean intersects = this.intersects(sstable);
                boolean hasRequiredStatics = this.hasRequiredStatics(sstable);
                boolean hasPartitionLevelDeletions = this.hasPartitionLevelDeletions(sstable);
                if (!(intersects || hasRequiredStatics || hasPartitionLevelDeletions)) {
                    ++nonIntersectingSSTables;
                    continue;
                }
                if (intersects || hasRequiredStatics) {
                    if (!sstable.isRepaired()) {
                        controller.updateMinOldestUnrepairedTombstone(sstable.getMinLocalDeletionTime());
                    }
                    iter3 = intersects ? this.makeRowIteratorWithLowerBound(cfs, sstable, metricsCollector) : this.makeRowIteratorWithSkippedNonStaticContent(cfs, sstable, metricsCollector);
                    inputCollector.addSSTableIterator(sstable, iter3);
                    mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter3.partitionLevelDeletion().markedForDeleteAt());
                    continue;
                }
                ++nonIntersectingSSTables;
                iter3 = this.makeRowIteratorWithSkippedNonStaticContent(cfs, sstable, metricsCollector);
                if (!iter3.partitionLevelDeletion().isLive()) {
                    if (!sstable.isRepaired()) {
                        controller.updateMinOldestUnrepairedTombstone(sstable.getMinLocalDeletionTime());
                    }
                    inputCollector.addSSTableIterator(sstable, iter3);
                    ++includedDueToTombstones;
                    mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter3.partitionLevelDeletion().markedForDeleteAt());
                    continue;
                }
                iter3.close();
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            if (inputCollector.isEmpty()) {
                return EmptyIterators.unfilteredRow(cfs.metadata(), this.partitionKey(), filter.isReversed());
            }
            StorageHook.instance.reportRead(cfs.metadata().id, this.partitionKey());
            List<UnfilteredRowIterator> iterators = inputCollector.finalizeIterators(cfs, this.nowInSec(), controller.oldestUnrepairedTombstone());
            return this.withSSTablesIterated(iterators, cfs.metric, metricsCollector);
        }
        catch (Error | RuntimeException e) {
            try {
                inputCollector.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    @Override
    protected boolean intersects(SSTableReader sstable) {
        return this.clusteringIndexFilter().intersects(sstable.metadata().comparator, sstable.getSSTableMetadata().coveredClustering);
    }

    private UnfilteredRowIteratorWithLowerBound makeRowIteratorWithLowerBound(ColumnFamilyStore cfs, SSTableReader sstable, SSTableReadsListener listener) {
        return StorageHook.instance.makeRowIteratorWithLowerBound(cfs, sstable, this.partitionKey(), this.clusteringIndexFilter(), this.columnFilter(), listener);
    }

    private UnfilteredRowIterator makeRowIterator(ColumnFamilyStore cfs, SSTableReader sstable, ClusteringIndexNamesFilter clusteringIndexFilter, SSTableReadsListener listener) {
        return StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), clusteringIndexFilter.getSlices(cfs.metadata()), this.columnFilter(), clusteringIndexFilter.isReversed(), listener);
    }

    private UnfilteredRowIterator makeRowIteratorWithSkippedNonStaticContent(ColumnFamilyStore cfs, SSTableReader sstable, SSTableReadsListener listener) {
        return StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), Slices.NONE, this.columnFilter(), this.clusteringIndexFilter().isReversed(), listener);
    }

    private UnfilteredRowIterator withSSTablesIterated(List<UnfilteredRowIterator> iterators, final TableMetrics metrics, final SSTableReadMetricsCollector metricsCollector) {
        UnfilteredRowIterator merged = UnfilteredRowIterators.merge(iterators);
        if (!merged.isEmpty()) {
            DecoratedKey key = merged.partitionKey();
            metrics.topReadPartitionFrequency.addSample(key.getKey(), 1);
            metrics.topReadPartitionSSTableCount.addSample(key.getKey(), metricsCollector.getMergedSSTables());
        }
        class UpdateSstablesIterated
        extends Transformation<UnfilteredRowIterator> {
            UpdateSstablesIterated() {
            }

            @Override
            public void onPartitionClose() {
                int mergedSSTablesIterated = metricsCollector.getMergedSSTables();
                metrics.updateSSTableIterated(mergedSSTablesIterated);
                Tracing.trace("Merged data from memtables and {} sstables", (Object)mergedSSTablesIterated);
            }
        }
        return Transformation.apply(merged, new UpdateSstablesIterated());
    }

    private boolean queriesMulticellType() {
        for (ColumnMetadata column : this.columnFilter().queriedColumns()) {
            if (!column.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    private UnfilteredRowIterator queryMemtableAndSSTablesInTimestampOrder(ColumnFamilyStore cfs, ClusteringIndexNamesFilter filter, ReadExecutionController controller) {
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        AbstractBTreePartition result = null;
        SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
        Tracing.trace("Merging memtable contents");
        for (Memtable memtable : view.memtables) {
            UnfilteredRowIterator iter2 = memtable.rowIterator(this.partitionKey, filter.getSlices(this.metadata()), this.columnFilter(), this.isReversed(), metricsCollector);
            try {
                if (iter2 == null) continue;
                result = this.add(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.MEMTABLE, false), (ImmutableBTreePartition)result, filter, false, controller);
            }
            finally {
                if (iter2 == null) continue;
                iter2.close();
            }
        }
        view.sstables.sort(SSTableReader.maxTimestampDescending);
        for (SSTableReader sstable : view.sstables) {
            UnfilteredRowIterator iter3;
            long currentMaxTs;
            if (result != null && sstable.getMaxTimestamp() < result.partitionLevelDeletion().markedForDeleteAt() || (filter = this.reduceFilter(filter, (ImmutableBTreePartition)result, currentMaxTs = sstable.getMaxTimestamp())) == null) break;
            boolean intersects = this.intersects(sstable);
            boolean hasRequiredStatics = this.hasRequiredStatics(sstable);
            boolean hasPartitionLevelDeletions = this.hasPartitionLevelDeletions(sstable);
            if (!intersects && !hasRequiredStatics) {
                if (!hasPartitionLevelDeletions) continue;
                iter3 = this.makeRowIteratorWithSkippedNonStaticContent(cfs, sstable, metricsCollector);
                try {
                    if (!iter3.partitionLevelDeletion().isLive()) {
                        result = this.add(UnfilteredRowIterators.noRowsIterator(iter3.metadata(), iter3.partitionKey(), Rows.EMPTY_STATIC_ROW, iter3.partitionLevelDeletion(), filter.isReversed()), (ImmutableBTreePartition)result, filter, sstable.isRepaired(), controller);
                        continue;
                    }
                    result = this.add(RTBoundValidator.validate(iter3, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired(), controller);
                    continue;
                }
                finally {
                    if (iter3 != null) {
                        iter3.close();
                    }
                    continue;
                }
            }
            iter3 = this.makeRowIterator(cfs, sstable, filter, metricsCollector);
            try {
                if (iter3.isEmpty()) continue;
                result = this.add(RTBoundValidator.validate(iter3, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired(), controller);
            }
            finally {
                if (iter3 == null) continue;
                iter3.close();
            }
        }
        cfs.metric.updateSSTableIterated(metricsCollector.getMergedSSTables());
        if (result == null || result.isEmpty()) {
            return EmptyIterators.unfilteredRow(this.metadata(), this.partitionKey(), false);
        }
        DecoratedKey key = result.partitionKey();
        cfs.metric.topReadPartitionFrequency.addSample(key.getKey(), 1);
        cfs.metric.topReadPartitionSSTableCount.addSample(key.getKey(), metricsCollector.getMergedSSTables());
        StorageHook.instance.reportRead(cfs.metadata.id, this.partitionKey());
        return result.unfilteredIterator(this.columnFilter(), Slices.ALL, this.clusteringIndexFilter().isReversed());
    }

    private ImmutableBTreePartition add(UnfilteredRowIterator iter2, ImmutableBTreePartition result, ClusteringIndexNamesFilter filter, boolean isRepaired, ReadExecutionController controller) {
        if (!isRepaired) {
            controller.updateMinOldestUnrepairedTombstone(iter2.stats().minLocalDeletionTime);
        }
        int maxRows = Math.max(filter.requestedRows().size(), 1);
        if (result == null) {
            return ImmutableBTreePartition.create(iter2, maxRows);
        }
        try (UnfilteredRowIterator merged = UnfilteredRowIterators.merge(Arrays.asList(iter2, result.unfilteredIterator(this.columnFilter(), Slices.ALL, filter.isReversed())));){
            ImmutableBTreePartition immutableBTreePartition = ImmutableBTreePartition.create(merged, maxRows);
            return immutableBTreePartition;
        }
    }

    private ClusteringIndexNamesFilter reduceFilter(ClusteringIndexNamesFilter filter, ImmutableBTreePartition result, long sstableTimestamp) {
        boolean hasNoMoreClusterings;
        if (result == null) {
            return filter;
        }
        RegularAndStaticColumns columns = this.metadata().isCompactTable() ? this.columnFilter().fetchedColumns() : this.columnFilter().queriedColumns();
        NavigableSet<Clustering<?>> clusterings = filter.requestedRows();
        boolean removeStatic = false;
        if (!columns.statics.isEmpty()) {
            Row staticRow = result.getRow(Clustering.STATIC_CLUSTERING);
            removeStatic = staticRow != null && this.isRowComplete(staticRow, columns.statics, sstableTimestamp);
        }
        TreeSet<Clusterable> toRemove = null;
        DeletionInfo deletionInfo = result.deletionInfo();
        if (deletionInfo.hasRanges()) {
            for (Clustering<?> clustering : clusterings) {
                RangeTombstone rt = deletionInfo.rangeCovering(clustering);
                if (rt == null || !rt.deletionTime().deletes(sstableTimestamp)) continue;
                if (toRemove == null) {
                    toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
                }
                toRemove.add(clustering);
            }
        }
        try (UnfilteredRowIterator iterator = result.unfilteredIterator(this.columnFilter(), clusterings, false);){
            while (iterator.hasNext()) {
                Row row;
                Unfiltered unfiltered = (Unfiltered)iterator.next();
                if (unfiltered == null || !unfiltered.isRow() || !this.isRowComplete(row = (Row)unfiltered, columns.regulars, sstableTimestamp)) continue;
                if (toRemove == null) {
                    toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
                }
                toRemove.add(row.clustering());
            }
        }
        if (!removeStatic && toRemove == null) {
            return filter;
        }
        boolean hasNoMoreStatic = columns.statics.isEmpty() || removeStatic;
        boolean bl = hasNoMoreClusterings = clusterings.isEmpty() || toRemove != null && toRemove.size() == clusterings.size();
        if (hasNoMoreStatic && hasNoMoreClusterings) {
            return null;
        }
        if (toRemove != null) {
            BTreeSet.Builder<Clusterable> newClusterings = BTreeSet.builder(result.metadata().comparator);
            newClusterings.addAll(Sets.difference(clusterings, toRemove));
            clusterings = newClusterings.build();
        }
        return new ClusteringIndexNamesFilter(clusterings, filter.isReversed());
    }

    private boolean isRowComplete(Row row, Columns requestedColumns, long sstableTimestamp) {
        if (!row.isStatic()) {
            if (!row.deletion().isLive() && row.deletion().time().deletes(sstableTimestamp)) {
                return true;
            }
            if (!this.metadata().isCompactTable() && (row.primaryKeyLivenessInfo().isEmpty() || row.primaryKeyLivenessInfo().timestamp() <= sstableTimestamp)) {
                return false;
            }
        }
        for (ColumnMetadata column : requestedColumns) {
            Cell<?> cell = row.getCell(column);
            if (cell != null && cell.timestamp() > sstableTimestamp) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean selectsFullPartition() {
        if (this.metadata().isStaticCompactTable()) {
            return true;
        }
        return this.clusteringIndexFilter.selectsAllPartition() && !this.rowFilter().hasExpressionOnClusteringOrRegularColumns();
    }

    public String toString() {
        return String.format("Read(%s columns=%s rowFilter=%s limits=%s key=%s filter=%s, nowInSec=%d)", this.metadata().toString(), this.columnFilter(), this.rowFilter(), this.limits(), this.metadata().partitionKeyType.getString(this.partitionKey().getKey()), this.clusteringIndexFilter.toString(this.metadata()), this.nowInSec());
    }

    @Override
    public Verb verb() {
        return Verb.READ_REQ;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        sb.append(" WHERE ").append(this.partitionKey().toCQLString(this.metadata()));
        String filterString = this.clusteringIndexFilter().toCQLString(this.metadata(), this.rowFilter());
        if (!filterString.isEmpty()) {
            if (!this.clusteringIndexFilter().selectsAllPartition() || !this.rowFilter().isEmpty()) {
                sb.append(" AND ");
            }
            sb.append(filterString);
        }
    }

    @Override
    public String loggableTokens() {
        return "token=" + this.partitionKey.getToken().toString();
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        this.metadata().partitionKeyType.writeValue(this.partitionKey().getKey(), out);
        ClusteringIndexFilter.serializer.serialize(this.clusteringIndexFilter(), out, version);
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return this.metadata().partitionKeyType.writtenLength(this.partitionKey().getKey()) + ClusteringIndexFilter.serializer.serializedSize(this.clusteringIndexFilter(), version);
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return true;
    }

    @Override
    public boolean isRangeRequest() {
        return false;
    }

    public static class VirtualTableSinglePartitionReadCommand
    extends SinglePartitionReadCommand {
        protected VirtualTableSinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, Index.QueryPlan indexQueryPlan, boolean trackWarnings, DataRange dataRange) {
            super(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexQueryPlan, trackWarnings, dataRange);
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
            return this.executeInternal(this.executionController());
        }

        @Override
        public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
            VirtualTable view = VirtualKeyspaceRegistry.instance.getTableNullable(this.metadata().id);
            UnfilteredPartitionIterator resultIterator = view.select(this.partitionKey, this.clusteringIndexFilter, this.columnFilter());
            return this.limits().filter(this.rowFilter().filter(resultIterator, this.nowInSec()), this.nowInSec(), this.selectsFullPartition());
        }

        @Override
        public ReadExecutionController executionController() {
            return ReadExecutionController.empty();
        }

        @Override
        public ReadExecutionController executionController(boolean trackRepairedStatus) {
            return this.executionController();
        }
    }

    private static final class SSTableReadMetricsCollector
    implements SSTableReadsListener {
        private int mergedSSTables;

        private SSTableReadMetricsCollector() {
        }

        @Override
        public void onSSTableSelected(SSTableReader sstable, SSTableReadsListener.SelectionReason reason) {
            sstable.incrementReadCount();
            ++this.mergedSSTables;
        }

        public int getMergedSSTables() {
            return this.mergedSSTables;
        }
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, Index.QueryPlan indexQueryPlan) throws IOException {
            DecoratedKey key = metadata.partitioner.decorateKey(metadata.partitionKeyType.readBuffer(in, DatabaseDescriptor.getMaxValueSize()));
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            return SinglePartitionReadCommand.create(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, key, filter, indexQueryPlan, false);
        }
    }

    public static class VirtualTableGroup
    extends Group {
        public VirtualTableGroup(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            super(commands, limits);
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
            if (this.queries.size() == 1) {
                return ((SinglePartitionReadCommand)this.queries.get(0)).execute(consistency, state, requestTime);
            }
            return PartitionIterators.concat(this.queries.stream().map(q -> q.execute(consistency, state, requestTime)).collect(Collectors.toList()));
        }
    }

    public static class Group
    extends SinglePartitionReadQuery.Group<SinglePartitionReadCommand> {
        public static Group create(TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, List<DecoratedKey> partitionKeys, ClusteringIndexFilter clusteringIndexFilter) {
            ArrayList<SinglePartitionReadCommand> commands = new ArrayList<SinglePartitionReadCommand>(partitionKeys.size());
            for (DecoratedKey partitionKey : partitionKeys) {
                commands.add(SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter));
            }
            return Group.create(commands, limits);
        }

        private Group(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            super(commands, limits);
        }

        public static Group one(SinglePartitionReadCommand command) {
            return Group.create(Collections.singletonList(command), command.limits());
        }

        public static Group create(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            return commands.get(0).metadata().isVirtual() ? new VirtualTableGroup(commands, limits) : new Group(commands, limits);
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
            return StorageProxy.read(this, consistency, requestTime);
        }
    }
}

