/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SimpleCachedBufferPool;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.SyncUtil;

public class MemoryMappedSegment
extends CommitLogSegment {
    private final int fd;

    MemoryMappedSegment(AbstractCommitLogSegmentManager manager, ThrowingFunction<Path, FileChannel, IOException> channelFactory) {
        super(manager, channelFactory);
        int firstSync = this.buffer.position();
        this.buffer.putInt(firstSync + 0, 0);
        this.buffer.putInt(firstSync + 4, 0);
        this.fd = NativeLibrary.getfd(this.channel);
    }

    @Override
    protected ByteBuffer createBuffer() {
        try {
            MappedByteBuffer mappedFile = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, DatabaseDescriptor.getCommitLogSegmentSize());
            this.manager.addSize(DatabaseDescriptor.getCommitLogSegmentSize());
            return mappedFile;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.logFile);
        }
    }

    @Override
    void write(int startMarker, int nextMarker) {
        if (nextMarker <= this.buffer.capacity() - 8) {
            this.buffer.putInt(nextMarker, 0);
            this.buffer.putInt(nextMarker + 4, 0);
        }
        MemoryMappedSegment.writeSyncMarker(this.id, this.buffer, startMarker, startMarker, nextMarker);
    }

    @Override
    protected void flush(int startMarker, int nextMarker) {
        try {
            SyncUtil.force((MappedByteBuffer)this.buffer);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        NativeLibrary.trySkipCache(this.fd, (long)startMarker, nextMarker, this.logFile.absolutePath());
    }

    @Override
    public long onDiskSize() {
        return DatabaseDescriptor.getCommitLogSegmentSize();
    }

    @Override
    protected void internalClose() {
        FileUtils.clean(this.buffer);
        super.internalClose();
    }

    protected static class MemoryMappedSegmentBuilder
    extends CommitLogSegment.Builder {
        public MemoryMappedSegmentBuilder(AbstractCommitLogSegmentManager segmentManager) {
            super(segmentManager);
        }

        @Override
        public MemoryMappedSegment build() {
            return new MemoryMappedSegment(this.segmentManager, path -> FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE));
        }

        @Override
        public SimpleCachedBufferPool createBufferPool() {
            return null;
        }
    }
}

