/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.StringType;
import org.apache.cassandra.serializers.AsciiSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.JsonUtils;

public class AsciiType
extends StringType {
    public static final AsciiType instance = new AsciiType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose("****");
    private final FastThreadLocal<CharsetEncoder> encoder = new FastThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return StandardCharsets.US_ASCII.newEncoder();
        }
    };

    AsciiType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public ByteBuffer fromString(String source) {
        CharsetEncoder theEncoder = this.encoder.get();
        theEncoder.reset();
        try {
            return theEncoder.encode(CharBuffer.wrap(source));
        }
        catch (CharacterCodingException exc) {
            throw new MarshalException(String.format("Invalid ASCII character in string literal: %s", exc));
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected an ascii string, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        try {
            return "\"" + JsonUtils.quoteAsJsonString(ByteBufferUtil.string(buffer, StandardCharsets.US_ASCII)) + "\"";
        }
        catch (CharacterCodingException exc) {
            throw new AssertionError("ascii value contained non-ascii characters: ", exc);
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.ASCII;
    }

    @Override
    public TypeSerializer<String> getSerializer() {
        return AsciiSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

