/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TupleSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class TupleType
extends AbstractType<ByteBuffer> {
    private static final String COLON = ":";
    private static final Pattern COLON_PAT = Pattern.compile(":");
    private static final String ESCAPED_COLON = "\\\\:";
    private static final Pattern ESCAPED_COLON_PAT = Pattern.compile("\\\\:");
    private static final String AT = "@";
    private static final Pattern AT_PAT = Pattern.compile("@");
    private static final String ESCAPED_AT = "\\\\@";
    private static final Pattern ESCAPED_AT_PAT = Pattern.compile("\\\\@");
    protected final List<AbstractType<?>> types;
    private final TupleSerializer serializer;

    public TupleType(List<AbstractType<?>> types) {
        this(types, true);
    }

    @VisibleForTesting
    public TupleType(List<AbstractType<?>> types, boolean freezeInner) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.types = freezeInner ? Lists.newArrayList(Iterables.transform(types, AbstractType::freeze)) : types;
        this.serializer = new TupleSerializer(TupleType.fieldSerializers(types));
    }

    @Override
    public boolean allowsEmpty() {
        return true;
    }

    private static List<TypeSerializer<?>> fieldSerializers(List<AbstractType<?>> types) {
        int size = types.size();
        ArrayList serializers = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            serializers.add(types.get(i).getSerializer());
        }
        return serializers;
    }

    public static TupleType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> types = parser.getTypeParameters();
        for (int i = 0; i < types.size(); ++i) {
            types.set(i, types.get(i).freeze());
        }
        return new TupleType(types);
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return Iterables.any(this.types, t2 -> t2.referencesUserType(name, accessor));
    }

    public TupleType withUpdatedUserType(UserType udt) {
        return this.referencesUserType(udt.name) ? new TupleType(Lists.newArrayList(Iterables.transform(this.types, t2 -> t2.withUpdatedUserType(udt)))) : this;
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return new TupleType(Lists.newArrayList(Iterables.transform(this.types, AbstractType::expandUserTypes)));
    }

    @Override
    public boolean referencesDuration() {
        return this.allTypes().stream().anyMatch(f -> f.referencesDuration());
    }

    public AbstractType<?> type(int i) {
        return this.types.get(i);
    }

    public int size() {
        return this.types.size();
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return this.types;
    }

    public List<AbstractType<?>> allTypes() {
        return this.types;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int offsetL = 0;
        int offsetR = 0;
        for (int i = 0; !accessorL.isEmptyFromOffset(left, offsetL) && !accessorR.isEmptyFromOffset(right, offsetR) && i < this.types.size(); ++i) {
            AbstractType<?> comparator = this.types.get(i);
            int sizeL = accessorL.getInt(left, offsetL);
            offsetL += 4;
            int sizeR = accessorR.getInt(right, offsetR);
            offsetR += 4;
            if (sizeL < 0) {
                if (sizeR < 0) continue;
                return -1;
            }
            if (sizeR < 0) {
                return 1;
            }
            VL valueL = accessorL.slice(left, offsetL, sizeL);
            offsetL += sizeL;
            VR valueR = accessorR.slice(right, offsetR, sizeR);
            offsetR += sizeR;
            int cmp = comparator.compare(valueL, accessorL, valueR, accessorR);
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.allRemainingComponentsAreNull(left, accessorL, offsetL) && this.allRemainingComponentsAreNull(right, accessorR, offsetR)) {
            return 0;
        }
        if (accessorL.isEmptyFromOffset(left, offsetL)) {
            return this.allRemainingComponentsAreNull(right, accessorR, offsetR) ? 0 : -1;
        }
        return this.allRemainingComponentsAreNull(left, accessorL, offsetL) ? 0 : 1;
    }

    private <T> boolean allRemainingComponentsAreNull(T v, ValueAccessor<T> accessor, int offset) {
        while (!accessor.isEmptyFromOffset(v, offset)) {
            int size = accessor.getInt(v, offset);
            offset += 4;
            if (size < 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        switch (version) {
            case LEGACY: {
                return this.asComparableBytesLegacy(accessor, data);
            }
            case OSS50: {
                return this.asComparableBytesNew(accessor, data, version);
            }
        }
        throw new AssertionError();
    }

    private <V> ByteSource asComparableBytesLegacy(ValueAccessor<V> accessor, V data) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        V[] bufs = this.split(accessor, data);
        ByteSource[] srcs = new ByteSource[this.types.size()];
        for (int i = 0; i < bufs.length; ++i) {
            srcs[i] = bufs[i] != null ? this.types.get(i).asComparableBytes(accessor, bufs[i], ByteComparable.Version.LEGACY) : null;
        }
        return ByteSource.withTerminatorLegacy(-1, srcs);
    }

    private <V> ByteSource asComparableBytesNew(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        V[] bufs = this.split(accessor, data);
        int lengthWithoutTrailingNulls = 0;
        for (int i = 0; i < bufs.length; ++i) {
            if (bufs[i] == null) continue;
            lengthWithoutTrailingNulls = i + 1;
        }
        ByteSource[] srcs = new ByteSource[lengthWithoutTrailingNulls];
        for (int i = 0; i < lengthWithoutTrailingNulls; ++i) {
            srcs[i] = bufs[i] != null ? this.types.get(i).asComparableBytes(accessor, bufs[i], version) : null;
        }
        return ByteSource.withTerminator(56, srcs);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        assert (version == ByteComparable.Version.OSS50);
        if (comparableBytes == null) {
            return accessor.empty();
        }
        V[] componentBuffers = accessor.createArray(this.types.size());
        for (int i = 0; i < this.types.size() && comparableBytes.peek() != 56; ++i) {
            AbstractType<?> componentType = this.types.get(i);
            ByteSource.Peekable component = ByteSourceInverse.nextComponentSource(comparableBytes);
            componentBuffers[i] = component != null ? componentType.fromComparableBytes(accessor, component, version) : null;
        }
        int terminator = comparableBytes.next();
        assert (terminator == 56) : String.format("Expected TERMINATOR (0x%2x) after %d components", 56, this.types.size());
        return TupleType.buildValue(accessor, componentBuffers);
    }

    public <V> V[] split(ValueAccessor<V> accessor, V value) {
        return TupleType.split(accessor, value, this.size(), this);
    }

    public static <V> V[] split(ValueAccessor<V> accessor, V value, int numberOfElements, TupleType type) {
        V[] components = accessor.createArray(numberOfElements);
        int length = accessor.size(value);
        int position = 0;
        for (int i = 0; i < numberOfElements; ++i) {
            if (position == length) {
                return Arrays.copyOfRange(components, 0, i);
            }
            if (position + 4 > length) {
                throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
            }
            int size = accessor.getInt(value, position);
            position += 4;
            if (size >= 0) {
                if (position + size > length) {
                    throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
                }
                components[i] = accessor.slice(value, position, size);
                position += size;
                continue;
            }
            components[i] = null;
        }
        if (position < length) {
            throw new MarshalException(String.format("Expected %s %s for %s column, but got more", numberOfElements, numberOfElements == 1 ? "value" : "values", type.asCQL3Type()));
        }
        return components;
    }

    @SafeVarargs
    public static <V> V buildValue(ValueAccessor<V> accessor, V ... components) {
        int totalLength = 0;
        for (V component : components) {
            totalLength += 4 + (component == null ? 0 : accessor.size(component));
        }
        int offset = 0;
        V result = accessor.allocate(totalLength);
        for (V component : components) {
            if (component == null) {
                offset += accessor.putInt(result, offset, -1);
                continue;
            }
            offset += accessor.putInt(result, offset, accessor.size(component));
            offset += accessor.copyTo(component, 0, result, accessor, offset, accessor.size(component));
        }
        return result;
    }

    public static ByteBuffer buildValue(ByteBuffer ... components) {
        return TupleType.buildValue(ByteBufferAccessor.instance, components);
    }

    @Override
    public <V> String getString(V input, ValueAccessor<V> accessor) {
        if (input == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (accessor.isEmptyFromOffset(input, offset)) {
                return sb.toString();
            }
            if (i > 0) {
                sb.append(COLON);
            }
            AbstractType<?> type = this.type(i);
            int size = accessor.getInt(input, offset);
            offset += 4;
            if (size < 0) {
                sb.append(AT);
                continue;
            }
            V field = accessor.slice(input, offset, size);
            offset += size;
            String fld = COLON_PAT.matcher(type.getString(field, accessor)).replaceAll(ESCAPED_COLON);
            fld = AT_PAT.matcher(fld).replaceAll(ESCAPED_AT);
            sb.append(fld);
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> fieldStrings = AbstractCompositeType.split(source);
        if (fieldStrings.size() > this.size()) {
            throw new MarshalException(String.format("Invalid tuple literal: too many elements. Type %s expects %d but got %d", this.asCQL3Type(), this.size(), fieldStrings.size()));
        }
        ByteBuffer[] fields = new ByteBuffer[fieldStrings.size()];
        for (int i = 0; i < fieldStrings.size(); ++i) {
            String fieldString = fieldStrings.get(i);
            if (fieldString.equals(AT)) continue;
            AbstractType<?> type = this.type(i);
            fieldString = ESCAPED_COLON_PAT.matcher(fieldString).replaceAll(COLON);
            fieldString = ESCAPED_AT_PAT.matcher(fieldString).replaceAll(AT);
            fields[i] = type.fromString(fieldString);
        }
        return TupleType.buildValue(fields);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = JsonUtils.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list representation of a tuple, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        if (list.size() > this.types.size()) {
            throw new MarshalException(String.format("Tuple contains extra items (expected %s): %s", this.types.size(), parsed));
        }
        if (this.types.size() > list.size()) {
            throw new MarshalException(String.format("Tuple is missing items (expected %s): %s", this.types.size(), parsed));
        }
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        Iterator<AbstractType<?>> typeIterator = this.types.iterator();
        for (Object element : list) {
            if (element == null) {
                typeIterator.next();
                terms.add(Constants.NULL_VALUE);
                continue;
            }
            terms.add(typeIterator.next().fromJSONObject(element));
        }
        return new Tuples.DelayedValue(this, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        ByteBuffer duplicated = buffer.duplicate();
        int offset = 0;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.types.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ByteBuffer value = CollectionSerializer.readValue(duplicated, ByteBufferAccessor.instance, offset);
            offset += CollectionSerializer.sizeOfValue(value, ByteBufferAccessor.instance);
            if (value == null) {
                sb.append("null");
                continue;
            }
            sb.append(this.types.get(i).toJSONString(value, protocolVersion));
        }
        return sb.append("]").toString();
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (!(previous instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)previous;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (!(otherType instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)otherType;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.types);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != TupleType.class) {
            return false;
        }
        TupleType that = (TupleType)o;
        return this.types.equals(that.types);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Tuple.create(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types, true);
    }

    @Override
    public ByteBuffer getMaskedValue() {
        ByteBuffer[] buffers = new ByteBuffer[this.types.size()];
        for (int i = 0; i < this.types.size(); ++i) {
            AbstractType<?> type = this.types.get(i);
            buffers[i] = type.getMaskedValue();
        }
        return this.serializer.serialize(TupleType.buildValue(buffers));
    }
}

