/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.hints.HintsServiceEvent;

final class HintsServiceDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private HintsServiceDiagnostics() {
    }

    static void dispatchingStarted(HintsService hintsService) {
        if (HintsServiceDiagnostics.isEnabled(HintsServiceEvent.HintsServiceEventType.DISPATCHING_STARTED)) {
            service.publish(new HintsServiceEvent(HintsServiceEvent.HintsServiceEventType.DISPATCHING_STARTED, hintsService));
        }
    }

    static void dispatchingShutdown(HintsService hintsService) {
        if (HintsServiceDiagnostics.isEnabled(HintsServiceEvent.HintsServiceEventType.DISPATCHING_SHUTDOWN)) {
            service.publish(new HintsServiceEvent(HintsServiceEvent.HintsServiceEventType.DISPATCHING_SHUTDOWN, hintsService));
        }
    }

    static void dispatchingPaused(HintsService hintsService) {
        if (HintsServiceDiagnostics.isEnabled(HintsServiceEvent.HintsServiceEventType.DISPATCHING_PAUSED)) {
            service.publish(new HintsServiceEvent(HintsServiceEvent.HintsServiceEventType.DISPATCHING_PAUSED, hintsService));
        }
    }

    static void dispatchingResumed(HintsService hintsService) {
        if (HintsServiceDiagnostics.isEnabled(HintsServiceEvent.HintsServiceEventType.DISPATCHING_RESUMED)) {
            service.publish(new HintsServiceEvent(HintsServiceEvent.HintsServiceEventType.DISPATCHING_RESUMED, hintsService));
        }
    }

    private static boolean isEnabled(HintsServiceEvent.HintsServiceEventType type) {
        return service.isEnabled(HintsServiceEvent.class, type);
    }
}

