/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.MetricsProviders;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;

public interface SSTableFormat<R extends SSTableReader, W extends SSTableWriter> {
    public String name();

    public Version getLatestVersion();

    public Version getVersion(String var1);

    public SSTableWriterFactory<W, ?> getWriterFactory();

    public SSTableReaderFactory<R, ?> getReaderFactory();

    public Set<Component> allComponents();

    public Set<Component> primaryComponents();

    public Set<Component> batchComponents();

    public Set<Component> uploadComponents();

    public Set<Component> mutableComponents();

    public Set<Component> generatedOnLoadComponents();

    public KeyCacheValueSerializer<R, ?> getKeyCacheValueSerializer();

    public IScrubber getScrubber(ColumnFamilyStore var1, LifecycleTransaction var2, OutputHandler var3, IScrubber.Options var4);

    public MetricsProviders getFormatSpecificMetricsProviders();

    public void deleteOrphanedComponents(Descriptor var1, Set<Component> var2);

    public void delete(Descriptor var1);

    public static interface Factory {
        public String name();

        public SSTableFormat<?, ?> getInstance(@Nonnull Map<String, String> var1);
    }

    public static interface KeyCacheValueSerializer<R extends SSTableReader, T extends AbstractRowIndexEntry> {
        public void skip(DataInputPlus var1) throws IOException;

        public T deserialize(R var1, DataInputPlus var2) throws IOException;

        public void serialize(T var1, DataOutputPlus var2) throws IOException;
    }

    public static class Components {
        public static final Component DATA = Types.DATA.getSingleton();
        public static final Component COMPRESSION_INFO = Types.COMPRESSION_INFO.getSingleton();
        public static final Component STATS = Types.STATS.getSingleton();
        public static final Component FILTER = Types.FILTER.getSingleton();
        public static final Component DIGEST = Types.DIGEST.getSingleton();
        public static final Component CRC = Types.CRC.getSingleton();
        public static final Component TOC = Types.TOC.getSingleton();

        public static class Types {
            public static final Component.Type DATA = Component.Type.createSingleton("DATA", "Data.db", true, null);
            public static final Component.Type COMPRESSION_INFO = Component.Type.createSingleton("COMPRESSION_INFO", "CompressionInfo.db", true, null);
            public static final Component.Type STATS = Component.Type.createSingleton("STATS", "Statistics.db", true, null);
            public static final Component.Type FILTER = Component.Type.createSingleton("FILTER", "Filter.db", true, null);
            public static final Component.Type DIGEST = Component.Type.createSingleton("DIGEST", "Digest.crc32", true, null);
            public static final Component.Type CRC = Component.Type.createSingleton("CRC", "CRC.db", true, null);
            public static final Component.Type TOC = Component.Type.createSingleton("TOC", "TOC.txt", false, null);
            public static final Component.Type SECONDARY_INDEX = Component.Type.create("SECONDARY_INDEX", "SI_.*.db", false, null);
            public static final Component.Type CUSTOM = Component.Type.create("CUSTOM", null, true, null);
        }
    }

    public static interface SSTableWriterFactory<W extends SSTableWriter, B extends SSTableWriter.Builder<W, B>> {
        public B builder(Descriptor var1);

        public long estimateSize(SSTableWriter.SSTableSizeParameters var1);
    }

    public static interface SSTableReaderFactory<R extends SSTableReader, B extends SSTableReader.Builder<R, B>> {
        public SSTableReader.Builder<R, B> builder(Descriptor var1);

        public SSTableReaderLoadingBuilder<R, B> loadingBuilder(Descriptor var1, TableMetadataRef var2, Set<Component> var3);

        public Pair<DecoratedKey, DecoratedKey> readKeyRange(Descriptor var1, IPartitioner var2) throws IOException;

        public Class<R> getReaderClass();
    }
}

