/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.security.JREProvider;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCryptoProvider {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCryptoProvider.class);
    public static final String FAIL_ON_MISSING_PROVIDER_KEY = "fail_on_missing_provider";
    protected final boolean failOnMissingProvider;
    private final Map<String, String> properties;

    public AbstractCryptoProvider(Map<String, String> args) {
        this.properties = args == null ? new HashMap() : args;
        boolean failOnMissingProviderFromProperties = Boolean.parseBoolean(this.properties.getOrDefault(FAIL_ON_MISSING_PROVIDER_KEY, "false"));
        this.failOnMissingProvider = CassandraRelevantProperties.FAIL_ON_MISSING_CRYPTO_PROVIDER.getBoolean(failOnMissingProviderFromProperties);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public abstract String getProviderName();

    public abstract String getProviderClassAsString();

    protected abstract Runnable installator();

    protected abstract boolean isHealthyInstallation() throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install() throws Exception {
        Object failureMessage = null;
        Throwable t2 = null;
        try {
            block15: {
                if (JREProvider.class.getName().equals(this.getProviderClassAsString())) {
                    logger.info(String.format("Installation of a crypto provider was skipped as %s was used.", JREProvider.class.getName()));
                    return;
                }
                FBUtilities.classForName(this.getProviderClassAsString(), "crypto provider");
                String providerName = this.getProviderName();
                int providerPosition = this.getProviderPosition(providerName);
                if (providerPosition > 0) {
                    if (providerPosition == 1) {
                        logger.info("{} was already installed on position {}.", (Object)providerName, (Object)providerPosition);
                        break block15;
                    } else {
                        if (this.failOnMissingProvider) {
                            throw new IllegalStateException(String.format("%s was already installed on position %s.", providerName, providerPosition));
                        }
                        logger.warn("{} was already installed on position {}. Check the configuration of JRE and either remove the provider from java.security or do not install this provider by Cassandra.", (Object)providerName, (Object)providerPosition);
                        return;
                    }
                }
                Runnable r = this.installator();
                if (r == null) {
                    throw new IllegalStateException("Installator runnable can not be null!");
                }
                r.run();
            }
            if (this.isHealthyInstallation()) {
                logger.info("{} health check OK.", (Object)this.getProviderName());
            } else {
                failureMessage = String.format("%s has not passed the health check. Check node's architecture (`uname -m`) is supported, see lib/<arch> subdirectories. The correct architecture-specific library for %s needs to be on the classpath. ", this.getProviderName(), this.getProviderClassAsString());
            }
        }
        catch (ConfigurationException ex) {
            failureMessage = this.getProviderClassAsString() + " is not on the class path! Check node's architecture (`uname -m`) is supported, see lib/<arch> subdirectories. The correct architecture-specific library for needs to be on the classpath.";
        }
        catch (Throwable ex) {
            failureMessage = String.format("The installation of %s was not successful, reason: %s", this.getProviderClassAsString(), ex.getMessage());
            t2 = ex;
        }
        if (failureMessage != null) {
            try {
                this.uninstall();
            }
            catch (Throwable throwable) {
                logger.warn("Uninstallation of {} failed", (Object)this.getProviderName(), (Object)throwable);
            }
            if (this.failOnMissingProvider) {
                throw new ConfigurationException((String)failureMessage, t2);
            }
            logger.warn((String)failureMessage);
        }
    }

    public void uninstall() {
        Security.removeProvider(this.getProviderName());
    }

    private int getProviderPosition(String providerName) {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getName().equals(providerName)) continue;
            return i + 1;
        }
        return -1;
    }
}

