/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.async;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.net.AsyncStreamingInputPlus;
import org.apache.cassandra.net.AsyncStreamingOutputPlus;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.StreamingDataInputPlus;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.StreamingDataOutputPlusFixed;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyStreamingChannel
extends ChannelInboundHandlerAdapter
implements StreamingChannel {
    private static final Logger logger = LoggerFactory.getLogger(NettyStreamingChannel.class);
    private static volatile boolean trackInboundHandlers = false;
    private static Collection<NettyStreamingChannel> inboundHandlers;
    @VisibleForTesting
    static final AttributeKey<Boolean> TRANSFERRING_FILE_ATTR;
    final Channel channel;
    @VisibleForTesting
    final AsyncStreamingInputPlus in;
    private volatile boolean closed;

    public NettyStreamingChannel(Channel channel, StreamingChannel.Kind kind) {
        this.channel = channel;
        channel.attr(TRANSFERRING_FILE_ATTR).set(Boolean.FALSE);
        if (kind == StreamingChannel.Kind.CONTROL) {
            if (trackInboundHandlers) {
                inboundHandlers.add(this);
            }
            this.in = new AsyncStreamingInputPlus(channel);
        } else {
            this.in = null;
        }
    }

    @Override
    public Object id() {
        return this.channel.id();
    }

    @Override
    public String description() {
        return "channel.remote " + this.channel.remoteAddress() + " channel.local " + this.channel.localAddress() + " channel.id " + this.channel.id();
    }

    @Override
    public InetSocketAddress peer() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public InetSocketAddress connectedTo() {
        return this.peer();
    }

    @Override
    public boolean connected() {
        return this.channel.isOpen();
    }

    @Override
    public StreamingDataInputPlus in() {
        return this.in;
    }

    @Override
    public StreamingDataOutputPlus acquireOut() {
        if (!this.channel.attr(TRANSFERRING_FILE_ATTR).compareAndSet(false, true)) {
            throw new IllegalStateException("channel's transferring state is currently set to true. refusing to start new stream");
        }
        return new AsyncStreamingOutputPlus(this.channel){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    NettyStreamingChannel.this.channel.attr(TRANSFERRING_FILE_ATTR).set(Boolean.FALSE);
                }
            }
        };
    }

    public Future<?> send(StreamingChannel.Send send) {
        class Factory
        implements IntFunction<StreamingDataOutputPlus> {
            ByteBuf buf;
            ByteBuffer buffer;

            Factory() {
            }

            @Override
            public StreamingDataOutputPlus apply(int size) {
                this.buf = GlobalBufferPoolAllocator.instance.buffer(size);
                this.buffer = this.buf.nioBuffer(this.buf.writerIndex(), size);
                return new StreamingDataOutputPlusFixed(this.buffer);
            }
        }
        Factory factory = new Factory();
        try {
            send.send(factory);
            ByteBuf buf = factory.buf;
            ByteBuffer buffer = factory.buffer;
            try {
                assert (buffer.position() == buffer.limit());
                buf.writerIndex(buffer.position());
                AsyncChannelPromise promise = new AsyncChannelPromise(this.channel);
                this.channel.writeAndFlush(buf, promise);
                return promise;
            }
            catch (Throwable t2) {
                buf.release();
                throw t2;
            }
        }
        catch (Throwable t3) {
            return ImmediateFuture.failure(t3);
        }
    }

    @Override
    public synchronized io.netty.util.concurrent.Future<?> close() {
        if (this.closed) {
            return this.channel.closeFuture();
        }
        this.closed = true;
        if (this.in != null) {
            this.in.requestClosure();
            if (trackInboundHandlers) {
                inboundHandlers.remove(this);
            }
        }
        return this.channel.close();
    }

    @Override
    public void onClose(Runnable runOnClose) {
        this.channel.closeFuture().addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)ignore -> runOnClose.run()));
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        if (this.closed || !(message instanceof ByteBuf) || !this.in.append((ByteBuf)message)) {
            ReferenceCountUtil.release(message);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.close();
        ctx.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            logger.trace("connection problem while streaming", cause);
        } else {
            logger.warn("exception occurred while in processing streaming data", cause);
        }
        this.close();
    }

    @VisibleForTesting
    public static void shutdown() {
        assert (trackInboundHandlers) : "in-JVM tests required tracking of inbound streaming handlers";
        inboundHandlers.forEach(NettyStreamingChannel::close);
        inboundHandlers.clear();
    }

    public static void trackInboundHandlers() {
        inboundHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        trackInboundHandlers = true;
    }

    static {
        TRANSFERRING_FILE_ATTR = AttributeKey.valueOf("transferringFile");
    }
}

