/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.messages.CompleteMessage;
import org.apache.cassandra.streaming.messages.IncomingStreamMessage;
import org.apache.cassandra.streaming.messages.KeepAliveMessage;
import org.apache.cassandra.streaming.messages.OutgoingStreamMessage;
import org.apache.cassandra.streaming.messages.PrepareAckMessage;
import org.apache.cassandra.streaming.messages.PrepareSynAckMessage;
import org.apache.cassandra.streaming.messages.PrepareSynMessage;
import org.apache.cassandra.streaming.messages.ReceivedMessage;
import org.apache.cassandra.streaming.messages.SessionFailedMessage;
import org.apache.cassandra.streaming.messages.StreamInitMessage;

public abstract class StreamMessage {
    public final Type type;

    public static void serialize(StreamMessage message, StreamingDataOutputPlus out, int version, StreamSession session) throws IOException {
        out.writeByte(message.type.id);
        message.type.outSerializer.serialize(message, out, version, session);
    }

    public static long serializedSize(StreamMessage message, int version) throws IOException {
        return 1L + message.type.outSerializer.serializedSize(message, version);
    }

    public static StreamMessage deserialize(DataInputPlus in, int version) throws IOException {
        Type type = Type.lookupById(in.readByte());
        return type.inSerializer.deserialize(in, version);
    }

    protected StreamMessage(Type type) {
        this.type = type;
    }

    public int getPriority() {
        return this.type.priority;
    }

    public StreamSession getOrCreateAndAttachInboundSession(StreamingChannel channel, int messagingVersion) {
        throw new UnsupportedOperationException("Not supported by streaming messages of type: " + this.getClass());
    }

    public static enum Type {
        PREPARE_SYN(1, 5, PrepareSynMessage.serializer),
        STREAM(2, 0, IncomingStreamMessage.serializer, OutgoingStreamMessage.serializer),
        RECEIVED(3, 4, ReceivedMessage.serializer),
        COMPLETE(5, 1, CompleteMessage.serializer),
        SESSION_FAILED(6, 5, SessionFailedMessage.serializer),
        KEEP_ALIVE(7, 5, KeepAliveMessage.serializer),
        PREPARE_SYNACK(8, 5, PrepareSynAckMessage.serializer),
        PREPARE_ACK(9, 5, PrepareAckMessage.serializer),
        STREAM_INIT(10, 5, StreamInitMessage.serializer);

        private static final Map<Integer, Type> idToTypeMap;
        public final int id;
        public final int priority;
        public final Serializer<StreamMessage> inSerializer;
        public final Serializer<StreamMessage> outSerializer;

        public static Type lookupById(int id) {
            Type t2 = idToTypeMap.get(id);
            if (t2 == null) {
                throw new IllegalArgumentException("Invalid type id: " + id);
            }
            return t2;
        }

        private Type(int id, int priority, Serializer serializer) {
            this(id, priority, serializer, serializer);
        }

        private Type(int id, int priority, Serializer inSerializer, Serializer outSerializer) {
            if (id < 0 || id > 127) {
                throw new IllegalArgumentException("StreamMessage Type id must be non-negative and less than 127");
            }
            this.id = id;
            this.priority = priority;
            this.inSerializer = inSerializer;
            this.outSerializer = outSerializer;
        }

        static {
            idToTypeMap = new HashMap<Integer, Type>();
            for (Type t2 : Type.values()) {
                if (idToTypeMap.put(t2.id, t2) == null) continue;
                throw new RuntimeException("Two StreamMessage Types map to the same id: " + t2.id);
            }
        }
    }

    public static interface Serializer<V extends StreamMessage> {
        public V deserialize(DataInputPlus var1, int var2) throws IOException;

        public void serialize(V var1, StreamingDataOutputPlus var2, int var3, StreamSession var4) throws IOException;

        public long serializedSize(V var1, int var2) throws IOException;
    }
}

