/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.gridkit.jvmtool.stacktrace.ThreadCapture;

public class ThreadStackSampler {
    private static final ObjectName THREADING_MBEAN = ThreadStackSampler.name("java.lang:type=Threading");
    private ThreadMXBean threading;
    private Pattern threadFilter;
    private List<String> frameFilter = new ArrayList<String>();
    private Map<StackTraceElement, Boolean> frameFilterCache = new HashMap<StackTraceElement, Boolean>();
    private Map<StackTraceElement, Integer> siteIndex = new HashMap<StackTraceElement, Integer>();
    private StackTraceElement[] sites = new StackTraceElement[0];
    private boolean[] siteFilterWhiteCache = new boolean[0];
    private boolean[] siteFilterBlackCache = new boolean[0];
    private long[] threadSet;
    private List<Trace> traces = new ArrayList<Trace>();

    private static ObjectName name(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ThreadStackSampler(MBeanServerConnection mserver) {
        this.threading = JMX.newMXBeanProxy(mserver, THREADING_MBEAN, ThreadMXBean.class);
    }

    public void setThreadFilter(String pattern) {
        this.threadFilter = Pattern.compile(pattern);
    }

    public void addFrame(String frameMatcher) {
        this.frameFilter.add(frameMatcher);
    }

    public void prime() {
        ThreadInfo[] ti = this.threading.dumpAllThreads(false, false);
        long[] tids = new long[ti.length];
        int n = 0;
        for (ThreadInfo t2 : ti) {
            long tid = t2.getThreadId();
            String name = t2.getThreadName();
            if (this.threadFilter != null && !this.threadFilter.matcher(name).matches()) continue;
            tids[n++] = tid;
        }
        tids = Arrays.copyOf(tids, n);
        this.threadSet = tids;
    }

    public int getTraceCount() {
        return this.traces.size();
    }

    public List<Trace> getTraces() {
        if (this.sites.length != this.siteIndex.size()) {
            this.sites = Arrays.copyOf(this.sites, this.siteIndex.size());
        }
        for (Trace t2 : this.traces) {
            Trace.access$002(t2, this.sites);
        }
        return new ArrayList<Trace>(this.traces);
    }

    public void clearTraces() {
        this.traces.clear();
        this.frameFilterCache.clear();
    }

    public void collect() {
        ThreadInfo[] dump;
        long timestamp = System.currentTimeMillis();
        for (ThreadInfo ti : dump = this.threading.getThreadInfo(this.threadSet, Integer.MAX_VALUE)) {
            Trace trace = this.newTrace(timestamp, ti);
            if (trace == null) continue;
            this.traces.add(trace);
        }
    }

    private Trace newTrace(long timestamp, ThreadInfo ti) {
        StackTraceElement[] stackTrace = ti.getStackTrace();
        int[] stack = new int[stackTrace.length];
        boolean match = this.frameFilter.isEmpty();
        for (int i = 0; i != stackTrace.length; ++i) {
            int siteId;
            stack[i] = siteId = this.toSiteID(stackTrace[i]);
            if (this.siteFilterWhiteCache[siteId]) {
                match = true;
                continue;
            }
            if (this.siteFilterBlackCache[siteId]) continue;
            boolean m4 = false;
            String frame = stackTrace[i].toString();
            for (String fe : this.frameFilter) {
                if (!frame.contains(fe)) continue;
                m4 = true;
                break;
            }
            if (m4) {
                match = true;
                this.siteFilterWhiteCache[siteId] = true;
                continue;
            }
            this.siteFilterBlackCache[siteId] = true;
        }
        if (match) {
            Trace trace = new Trace(ti.getThreadId(), timestamp, stack);
            return trace;
        }
        return null;
    }

    private int toSiteID(StackTraceElement e) {
        Integer i = this.siteIndex.get(e);
        if (i == null) {
            i = this.siteIndex.size();
            this.siteIndex.put(e, i);
            if (this.sites.length <= i) {
                this.sites = Arrays.copyOf(this.sites, 16 + 3 * this.sites.length / 2);
                this.siteFilterWhiteCache = Arrays.copyOf(this.siteFilterWhiteCache, this.sites.length);
                this.siteFilterBlackCache = Arrays.copyOf(this.siteFilterBlackCache, this.sites.length);
            }
            this.sites[i.intValue()] = e;
        }
        return i;
    }

    public static class Trace
    implements Serializable {
        private long threadId;
        private long timestamp;
        private int[] trace;
        private StackTraceElement[] traceDictionary;

        public Trace(long threadId, long timestamp, int[] trace) {
            this.threadId = threadId;
            this.timestamp = timestamp;
            this.trace = trace;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public StackTraceElement[] getTrace() {
            StackTraceElement[] strace = new StackTraceElement[this.trace.length];
            for (int i = 0; i != strace.length; ++i) {
                strace[i] = this.traceDictionary[this.trace[i]];
            }
            return strace;
        }

        public void copyToSnapshot(ThreadCapture snap) {
            snap.reset();
            snap.threadId = this.threadId;
            snap.timestamp = this.timestamp;
            snap.elements = this.getTrace();
        }

        static /* synthetic */ StackTraceElement[] access$002(Trace x0, StackTraceElement[] x1) {
            x0.traceDictionary = x1;
            return x1;
        }
    }
}

