/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class Runner {
    private static HashMap wantedJars = new HashMap();
    private static final String JAR_EXT = ".jar";

    private static void printMissingJars() {
        Iterator it = wantedJars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String jar = (String)entry.getKey();
            if (wantedJars.get(jar) != Boolean.FALSE) continue;
            System.out.println("Unable to locate: " + jar + JAR_EXT);
        }
    }

    private static boolean missingJars() {
        Iterator it = wantedJars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String jar = (String)entry.getKey();
            if (wantedJars.get(jar) != Boolean.FALSE) continue;
            return true;
        }
        return false;
    }

    public static URL[] getLibJars(String dir) throws Exception {
        File[] jars = new File(dir).listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                int jarIx = name.indexOf(Runner.JAR_EXT);
                if (jarIx == -1) {
                    return false;
                }
                int ix = name.indexOf(45);
                name = ix != -1 ? name.substring(0, ix) : name.substring(0, jarIx);
                if (wantedJars.get(name) != null) {
                    wantedJars.put(name, Boolean.TRUE);
                    return true;
                }
                return false;
            }
        });
        if (jars == null) {
            return new URL[0];
        }
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            URL url;
            urls[i] = url = new URL("jar", null, "file:" + jars[i].getAbsolutePath() + "!/");
        }
        return urls;
    }

    private static void addURLs(URL[] jars) throws Exception {
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        for (int i = 0; i < jars.length; ++i) {
            addURL.invoke((Object)loader, jars[i]);
        }
    }

    private static boolean addJarDir(String dir) throws Exception {
        URL[] jars = Runner.getLibJars(dir);
        Runner.addURLs(jars);
        return !Runner.missingJars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getenv(String key) {
        try {
            return System.getenv("ANT_HOME");
        }
        catch (Error e) {
            Sigar sigar = new Sigar();
            try {
                String string = sigar.getProcEnv("$$", "ANT_HOME");
                return string;
            }
            catch (Exception se) {
                String string = null;
                return string;
            }
            finally {
                sigar.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            args = new String[]{"Shell"};
        } else if (Character.isLowerCase(args[0].charAt(0))) {
            String[] nargs = new String[args.length + 1];
            System.arraycopy(args, 0, nargs, 1, args.length);
            nargs[0] = "Shell";
            args = nargs;
        }
        String name = args[0];
        String[] pargs = new String[args.length - 1];
        System.arraycopy(args, 1, pargs, 0, args.length - 1);
        String sigarLib = SigarLoader.getLocation();
        String[] dirs = new String[]{sigarLib, "lib", "."};
        for (int i = 0; i < dirs.length && !Runner.addJarDir(dirs[i]); ++i) {
        }
        if (Runner.missingJars()) {
            String home;
            File lib;
            File[] subdirs = new File(".").listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i = 0; !(i >= subdirs.length || (lib = new File(subdirs[i], "lib")).exists() && Runner.addJarDir(lib.getAbsolutePath())); ++i) {
            }
            if (Runner.missingJars() && (home = Runner.getenv("ANT_HOME")) != null) {
                Runner.addJarDir(home + "/lib");
            }
        }
        Class<?> cmd = null;
        String[] packages = new String[]{"org.hyperic.sigar.cmd.", "org.hyperic.sigar.test.", "org.hyperic.sigar.", "org.hyperic.sigar.win32.", "org.hyperic.sigar.jmx."};
        for (int i = 0; i < packages.length; ++i) {
            try {
                cmd = Class.forName(packages[i] + name);
                break;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
        }
        if (cmd == null) {
            System.out.println("Unknown command: " + args[0]);
            return;
        }
        Method main = cmd.getMethod("main", String;.class);
        try {
            main.invoke(null, new Object[]{pargs});
        }
        catch (InvocationTargetException e) {
            Throwable t2 = e.getTargetException();
            if (t2 instanceof NoClassDefFoundError) {
                System.out.println("Class Not Found: " + t2.getMessage());
                Runner.printMissingJars();
            }
            t2.printStackTrace();
        }
    }

    static {
        wantedJars.put("junit", Boolean.FALSE);
        wantedJars.put("log4j", Boolean.FALSE);
    }
}

