/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.geometry;

import org.psjava.goods.GoodLongHash;
import org.psjava.util.EqualityTester;
import org.psjava.util.StrictEqualityTester;

public class Azimuth
implements EqualityTester<Azimuth> {
    private static final double DOUBLE_PI = Math.PI * 2;
    private final double radian;

    public static Azimuth create(double radian) {
        return new Azimuth(radian);
    }

    public Azimuth(double radian) {
        if (Double.isNaN(radian)) {
            throw new IllegalArgumentException("Direction cannot be NaN");
        }
        this.radian = this.adjustRadian(radian);
    }

    private double adjustRadian(double radian) {
        if ((radian %= Math.PI * 2) < 0.0) {
            radian += Math.PI * 2;
        }
        if (radian >= Math.PI * 2) {
            radian = 0.0;
        }
        return radian;
    }

    public double radian() {
        return this.radian;
    }

    public final boolean equals(Object v) {
        return StrictEqualityTester.areEqual(this, v, this);
    }

    @Override
    public boolean areEqual(Azimuth o1, Azimuth o2) {
        return o1.radian == o2.radian;
    }

    public final int hashCode() {
        return GoodLongHash.hash(Double.doubleToLongBits(this.radian));
    }

    public String toString() {
        return "Azimuth(" + String.format("%.2f", this.radian) + "pi)";
    }
}

