/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.CdcEventBuilder;
import org.apache.cassandra.cdc.msg.FourZeroRangeTombstoneBuilder;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.reader.AbstractComplexTypeBuffer;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourZeroCdcEventBuilder
extends CdcEventBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FourZeroCdcEventBuilder.class);
    private TableMetadata tableMetadata;
    private UnfilteredRowIterator partition = null;

    FourZeroCdcEventBuilder(CdcEvent.Kind kind, UnfilteredRowIterator partition, String trackingId, CassandraSource cassandraSource) {
        this(kind, partition.metadata().keyspace, partition.metadata().name, trackingId, cassandraSource);
        this.tableMetadata = partition.metadata();
        this.partition = partition;
        this.setPartitionKeys(partition);
        this.setStaticColumns(partition);
    }

    FourZeroCdcEventBuilder(CdcEvent.Kind kind, String keyspace, String table, String trackingId, CassandraSource cassandraSource) {
        super(kind, keyspace, table, trackingId, cassandraSource);
        this.kind = kind;
        this.keyspace = keyspace;
        this.table = table;
        this.trackingId = trackingId;
        this.track = trackingId != null;
        this.cassandraSource = cassandraSource;
    }

    public static FourZeroCdcEventBuilder of(CdcEvent.Kind kind, UnfilteredRowIterator partition, String trackingId, CassandraSource cassandraSource) {
        return new FourZeroCdcEventBuilder(kind, partition, trackingId, cassandraSource);
    }

    public static CdcEvent build(CdcEvent.Kind kind, UnfilteredRowIterator partition, String trackingId, CassandraSource cassandraSource) {
        return FourZeroCdcEventBuilder.of(kind, partition, trackingId, cassandraSource).build();
    }

    public static CdcEvent build(CdcEvent.Kind kind, UnfilteredRowIterator partition, Row row, String trackingId, CassandraSource cassandraSource) {
        return FourZeroCdcEventBuilder.of(kind, partition, trackingId, cassandraSource).withRow(row).build();
    }

    public FourZeroCdcEventBuilder withRow(Row row) {
        Preconditions.checkNotNull((Object)this.partition, (Object)"Cannot build with an empty builder.");
        this.setClusteringKeys((Unfiltered)row, this.partition);
        this.setValueColumns(row);
        return this;
    }

    void setPartitionKeys(UnfilteredRowIterator partition) {
        if (this.kind == CdcEvent.Kind.PARTITION_DELETE) {
            this.updateMaxTimestamp(partition.partitionLevelDeletion().markedForDeleteAt());
        }
        ImmutableList columnMetadatas = partition.metadata().partitionKeyColumns();
        ArrayList<Value> pk = new ArrayList<Value>(columnMetadatas.size());
        ByteBuffer pkbb = partition.partitionKey().getKey();
        if (columnMetadatas.size() == 1) {
            pk.add(this.makeValue(pkbb, (ColumnMetadata)columnMetadatas.get(0)));
        } else {
            ByteBuffer[] pkbbs = ByteBufferUtils.split((ByteBuffer)pkbb, (int)columnMetadatas.size());
            for (int i = 0; i < columnMetadatas.size(); ++i) {
                pk.add(this.makeValue(pkbbs[i], (ColumnMetadata)columnMetadatas.get(i)));
            }
        }
        this.partitionKeys = pk;
    }

    void setStaticColumns(UnfilteredRowIterator partition) {
        Row staticRow = partition.staticRow();
        if (staticRow.isEmpty()) {
            return;
        }
        ArrayList<Value> sc = new ArrayList<Value>(staticRow.columnCount());
        for (ColumnData cd : staticRow) {
            this.addColumn(sc, cd);
        }
        this.staticColumns = sc;
    }

    void setClusteringKeys(Unfiltered unfiltered, UnfilteredRowIterator partition) {
        ImmutableList columnMetadatas = partition.metadata().clusteringColumns();
        if (columnMetadatas.isEmpty()) {
            return;
        }
        ArrayList<Value> ck = new ArrayList<Value>(columnMetadatas.size());
        for (ColumnMetadata cm : columnMetadatas) {
            ByteBuffer ckbb = unfiltered.clustering().bufferAt(cm.position());
            ck.add(this.makeValue(ckbb, cm));
        }
        this.clusteringKeys = ck;
    }

    void setValueColumns(Row row) {
        if (this.kind == CdcEvent.Kind.ROW_DELETE) {
            this.updateMaxTimestamp(row.deletion().time().markedForDeleteAt());
            return;
        }
        if (row.isEmpty()) {
            LOGGER.warn("Encountered an unexpected empty row in CDC. keyspace={}, table={}", (Object)this.keyspace, (Object)this.table);
            return;
        }
        ArrayList<Value> vc = new ArrayList<Value>(row.columnCount());
        for (ColumnData cd : row) {
            this.addColumn(vc, cd);
        }
        this.valueColumns = vc;
    }

    private void addColumn(List<Value> holder, ColumnData cd) {
        ColumnMetadata columnMetadata = cd.column();
        String columnName = columnMetadata.name.toCQLString();
        if (columnMetadata.isComplex()) {
            ComplexColumnData complex = (ComplexColumnData)cd;
            DeletionTime deletionTime = complex.complexDeletion();
            if (deletionTime.isLive()) {
                if (complex.column().type instanceof ListType) {
                    this.readFromCassandra(holder, complex);
                } else {
                    this.processComplexData(holder, complex);
                }
            } else if (complex.cellsCount() > 0) {
                this.processComplexData(holder, complex);
            } else {
                this.kind = CdcEvent.Kind.DELETE;
                this.updateMaxTimestamp(deletionTime.markedForDeleteAt());
                holder.add(this.makeValue(null, complex.column()));
            }
        } else {
            Cell cell = (Cell)cd;
            this.updateMaxTimestamp(cell.timestamp());
            if (cell.isTombstone()) {
                holder.add(this.makeValue(null, cell.column()));
            } else {
                holder.add(this.makeValue(cell.buffer(), cell.column()));
                if (cell.isExpiring()) {
                    this.setTTL(cell.ttl(), Cell.deletionTimeLongToUnsignedInteger((long)cell.localDeletionTime()));
                }
            }
        }
    }

    private void processComplexData(List<Value> holder, ComplexColumnData complex) {
        AbstractComplexTypeBuffer buffer = AbstractComplexTypeBuffer.newBuffer((AbstractType)complex.column().type, (int)complex.cellsCount());
        boolean allTombstone = true;
        String columnName = complex.column().name.toCQLString();
        for (Cell cell : complex) {
            this.updateMaxTimestamp(cell.timestamp());
            if (cell.isTombstone()) {
                this.kind = CdcEvent.Kind.COMPLEX_ELEMENT_DELETE;
                CellPath path = cell.path();
                if (path.size() <= 0) continue;
                this.addCellTombstoneInComplex(columnName, path.get(0));
                continue;
            }
            allTombstone = false;
            buffer.addCell(cell);
            if (!cell.isExpiring()) continue;
            this.setTTL(cell.ttl(), Cell.deletionTimeLongToUnsignedInteger((long)cell.localDeletionTime()));
        }
        if (allTombstone) {
            holder.add(this.makeValue(null, complex.column()));
        } else {
            holder.add(this.makeValue(buffer.pack(), complex.column()));
        }
    }

    private void readFromCassandra(List<Value> holder, ComplexColumnData complex) {
        this.updateMaxTimestamp(complex.maxTimestamp());
        ArrayList<Value> primaryKeyColumns = new ArrayList<Value>(this.getPrimaryKeyColumns());
        String columnName = complex.column().name.toCQLString();
        List valueRead = this.cassandraSource.readFromCassandra(this.keyspace, this.table, (List)ImmutableList.of((Object)columnName), primaryKeyColumns);
        if (valueRead == null) {
            LOGGER.warn("Unable to process element update inside a List type. Skipping...");
        } else {
            holder.add(this.makeValue((ByteBuffer)valueRead.get(0), complex.column()));
        }
    }

    private List<Value> getPrimaryKeyColumns() {
        if (this.clusteringKeys == null) {
            return this.partitionKeys;
        }
        ArrayList<Value> primaryKeys = new ArrayList<Value>(this.partitionKeys.size() + this.clusteringKeys.size());
        primaryKeys.addAll(this.partitionKeys);
        primaryKeys.addAll(this.clusteringKeys);
        return primaryKeys;
    }

    public Value makeValue(ByteBuffer value, ColumnMetadata columnMetadata) {
        return this.makeValue(columnMetadata.ksName, columnMetadata.name.toCQLString(), columnMetadata.type.asCQL3Type().toString(), value);
    }

    public Value makeValue(String keyspace, String name, String type, ByteBuffer value) {
        return new Value(keyspace, name, type, value);
    }

    public void addRangeTombstoneMarker(RangeTombstoneMarker marker) {
        if (this.rangeTombstoneList == null) {
            this.rangeTombstoneList = new ArrayList();
            this.rangeTombstoneBuilder = this.rangeTombstoneBuilder(this.tableMetadata);
        }
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker boundaryMarker = (RangeTombstoneBoundaryMarker)marker;
            this.updateMaxTimestamp(boundaryMarker.startDeletionTime().markedForDeleteAt());
            this.updateMaxTimestamp(boundaryMarker.endDeletionTime().markedForDeleteAt());
        } else {
            this.updateMaxTimestamp(((RangeTombstoneBoundMarker)marker).deletionTime().markedForDeleteAt());
        }
        ((FourZeroRangeTombstoneBuilder)this.rangeTombstoneBuilder).add(marker);
        if (this.rangeTombstoneBuilder.canBuild()) {
            this.rangeTombstoneList.add(this.rangeTombstoneBuilder.build());
        }
    }

    public FourZeroRangeTombstoneBuilder rangeTombstoneBuilder(TableMetadata metadata) {
        return new FourZeroRangeTombstoneBuilder(metadata);
    }
}

