/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.base.Splitter;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.utils.streaming.CassandraFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SSTable
implements Serializable,
CassandraFile {
    public static final long serialVersionUID = 42L;
    private static final String FILENAME_SEPARATOR = "-";
    private static final Splitter filenameSplitter = Splitter.on((String)"-");

    @Nullable
    protected abstract InputStream openInputStream(FileType var1);

    @Nullable
    public InputStream openCompressionStream() {
        return this.openInputStream(FileType.COMPRESSION_INFO);
    }

    @Nullable
    public InputStream openStatsStream() {
        return this.openInputStream(FileType.STATISTICS);
    }

    @Nullable
    public InputStream openSummaryStream() {
        return this.openInputStream(FileType.SUMMARY);
    }

    @Nullable
    public InputStream openPrimaryIndexStream() {
        return this.openInputStream(this.isBigFormat() ? FileType.INDEX : FileType.PARTITIONS_INDEX);
    }

    @Nullable
    public InputStream openRowIndexStream() {
        return this.openInputStream(FileType.ROWS_INDEX);
    }

    @Nullable
    public InputStream openFilterStream() {
        return this.openInputStream(FileType.FILTER);
    }

    @NotNull
    public InputStream openDataStream() {
        return Objects.requireNonNull(this.openInputStream(FileType.DATA), "Data.db SSTable file component must exist");
    }

    public abstract long length(FileType var1);

    public abstract boolean isMissing(FileType var1);

    public void verify() throws IncompleteSSTableException {
        if (this.isMissing(FileType.DATA)) {
            throw new IncompleteSSTableException(FileType.DATA);
        }
        if (this.isMissing(FileType.STATISTICS)) {
            throw new IncompleteSSTableException(FileType.STATISTICS);
        }
        if (this.isBigFormat() && this.isMissing(FileType.SUMMARY) && this.isMissing(FileType.INDEX)) {
            throw new IncompleteSSTableException(FileType.SUMMARY, FileType.INDEX);
        }
        if (this.isBtiFormat() && this.isMissing(FileType.PARTITIONS_INDEX)) {
            throw new IncompleteSSTableException(FileType.PARTITIONS_INDEX);
        }
    }

    public abstract String getDataFileName();

    public boolean isBigFormat() {
        return this.getDataFileName().contains("-big-");
    }

    public boolean isBtiFormat() {
        return this.getDataFileName().contains("-bti-");
    }

    public String getFormat() {
        List tokens = filenameSplitter.splitToList((CharSequence)this.getDataFileName());
        return (String)tokens.get(tokens.size() - 2);
    }

    public String getVersion() {
        List tokens = filenameSplitter.splitToList((CharSequence)this.getDataFileName());
        return (String)tokens.get(tokens.size() - 4);
    }
}

