/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.MD5Digest;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.commons.codec.digest.DigestUtils;

public class MD5DigestAlgorithm
implements DigestAlgorithm {
    @Override
    public Digest calculateFileDigest(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            MessageDigest computedMd5 = DigestUtils.updateDigest((MessageDigest)DigestUtils.getMd5Digest(), (InputStream)is);
            MD5Digest mD5Digest = new MD5Digest(Base64.getEncoder().encodeToString(computedMd5.digest()));
            return mD5Digest;
        }
    }
}

