/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeDefault;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeLeafWithValue;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeNonLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.charsequence.CharSequenceNodeNonLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.voidvalue.VoidValue;
import com.googlecode.concurrenttrees.radix.node.util.NodeUtil;
import java.util.List;

public class DefaultCharSequenceNodeFactory
implements NodeFactory {
    @Override
    public Node createNode(CharSequence edgeCharacters, Object value, List<Node> childNodes, boolean isRoot) {
        if (edgeCharacters == null) {
            throw new IllegalStateException("The edgeCharacters argument was null");
        }
        if (!isRoot && edgeCharacters.length() == 0) {
            throw new IllegalStateException("Invalid edge characters for non-root node: " + CharSequences.toString(edgeCharacters));
        }
        if (childNodes == null) {
            throw new IllegalStateException("The childNodes argument was null");
        }
        NodeUtil.ensureNoDuplicateEdges(childNodes);
        if (childNodes.isEmpty()) {
            if (value instanceof VoidValue) {
                return new CharSequenceNodeLeafVoidValue(edgeCharacters);
            }
            if (value != null) {
                return new CharSequenceNodeLeafWithValue(edgeCharacters, value);
            }
            return new CharSequenceNodeLeafNullValue(edgeCharacters);
        }
        if (value instanceof VoidValue) {
            return new CharSequenceNodeNonLeafVoidValue(edgeCharacters, childNodes);
        }
        if (value == null) {
            return new CharSequenceNodeNonLeafNullValue(edgeCharacters, childNodes);
        }
        return new CharSequenceNodeDefault(edgeCharacters, value, childNodes);
    }
}

