/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class Event {
    public final Type type;

    private Event(Type type) {
        this.type = type;
    }

    public static Event deserialize(ByteBuf cb, ProtocolVersion version) {
        Type eventType = CBUtil.readEnumValue(Type.class, cb);
        if (eventType.minimumVersion.isGreaterThan(version)) {
            throw new ProtocolException("Event " + eventType.name() + " not valid for protocol version " + version);
        }
        switch (eventType) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(cb, version);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(cb, version);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(cb, version);
            }
        }
        throw new AssertionError();
    }

    public void serialize(ByteBuf dest, ProtocolVersion version) {
        if (this.type.minimumVersion.isGreaterThan(version)) {
            throw new ProtocolException("Event " + this.type.name() + " not valid for protocol version " + version);
        }
        CBUtil.writeEnumValue(this.type, dest);
        this.serializeEvent(dest, version);
    }

    public int serializedSize(ProtocolVersion version) {
        return CBUtil.sizeOfEnumValue(this.type) + this.eventSerializedSize(version);
    }

    protected abstract void serializeEvent(ByteBuf var1, ProtocolVersion var2);

    protected abstract int eventSerializedSize(ProtocolVersion var1);

    public static class SchemaChange
    extends Event {
        public final Change change;
        public final Target target;
        public final String keyspace;
        public final String name;
        public final List<String> argTypes;

        public SchemaChange(Change change, Target target, String keyspace, String name, List<String> argTypes) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.target = target;
            this.keyspace = keyspace;
            this.name = name;
            if (target != Target.KEYSPACE) assert (this.name != null) : "Table, type, function or aggregate name should be set for non-keyspace schema change events";
            this.argTypes = argTypes;
        }

        public SchemaChange(Change change, Target target, String keyspace, String name) {
            this(change, target, keyspace, name, null);
        }

        public SchemaChange(Change change, String keyspace) {
            this(change, Target.KEYSPACE, keyspace, null);
        }

        public static SchemaChange forFunction(Change change, UDFunction function) {
            return new SchemaChange(change, Target.FUNCTION, function.name().keyspace, function.name().name, function.argumentsList());
        }

        public static SchemaChange forAggregate(Change change, UDAggregate aggregate) {
            return new SchemaChange(change, Target.AGGREGATE, aggregate.name().keyspace, aggregate.name().name, aggregate.argumentsList());
        }

        public static SchemaChange deserializeEvent(ByteBuf cb, ProtocolVersion version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V3)) {
                Target target = CBUtil.readEnumValue(Target.class, cb);
                String keyspace = CBUtil.readString(cb);
                String tableOrType = target == Target.KEYSPACE ? null : CBUtil.readString(cb);
                List<String> argTypes = null;
                if (target == Target.FUNCTION || target == Target.AGGREGATE) {
                    argTypes = CBUtil.readStringList(cb);
                }
                return new SchemaChange(change, target, keyspace, tableOrType, argTypes);
            }
            String keyspace = CBUtil.readString(cb);
            String table = CBUtil.readString(cb);
            return new SchemaChange(change, table.isEmpty() ? Target.KEYSPACE : Target.TABLE, keyspace, table.isEmpty() ? null : table);
        }

        @Override
        public void serializeEvent(ByteBuf dest, ProtocolVersion version) {
            if (this.target == Target.FUNCTION || this.target == Target.AGGREGATE) {
                if (version.isGreaterOrEqualTo(ProtocolVersion.V4)) {
                    CBUtil.writeEnumValue(this.change, dest);
                    CBUtil.writeEnumValue(this.target, dest);
                    CBUtil.writeAsciiString(this.keyspace, dest);
                    CBUtil.writeAsciiString(this.name, dest);
                    CBUtil.writeStringList(this.argTypes, dest);
                } else {
                    CBUtil.writeEnumValue(Change.UPDATED, dest);
                    if (version.isGreaterOrEqualTo(ProtocolVersion.V3)) {
                        CBUtil.writeEnumValue(Target.KEYSPACE, dest);
                    }
                    CBUtil.writeAsciiString(this.keyspace, dest);
                    CBUtil.writeAsciiString("", dest);
                }
                return;
            }
            if (version.isGreaterOrEqualTo(ProtocolVersion.V3)) {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeEnumValue(this.target, dest);
                CBUtil.writeAsciiString(this.keyspace, dest);
                if (this.target != Target.KEYSPACE) {
                    CBUtil.writeAsciiString(this.name, dest);
                }
            } else if (this.target == Target.TYPE) {
                CBUtil.writeEnumValue(Change.UPDATED, dest);
                CBUtil.writeAsciiString(this.keyspace, dest);
                CBUtil.writeAsciiString("", dest);
            } else {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeAsciiString(this.keyspace, dest);
                CBUtil.writeAsciiString(this.target == Target.KEYSPACE ? "" : this.name, dest);
            }
        }

        @Override
        public int eventSerializedSize(ProtocolVersion version) {
            if (this.target == Target.FUNCTION || this.target == Target.AGGREGATE) {
                if (version.isGreaterOrEqualTo(ProtocolVersion.V4)) {
                    return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfEnumValue(this.target) + CBUtil.sizeOfAsciiString(this.keyspace) + CBUtil.sizeOfAsciiString(this.name) + CBUtil.sizeOfStringList(this.argTypes);
                }
                if (version.isGreaterOrEqualTo(ProtocolVersion.V3)) {
                    return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfEnumValue(Target.KEYSPACE) + CBUtil.sizeOfAsciiString(this.keyspace);
                }
                return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfAsciiString(this.keyspace) + CBUtil.sizeOfAsciiString("");
            }
            if (version.isGreaterOrEqualTo(ProtocolVersion.V3)) {
                int size = CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfEnumValue(this.target) + CBUtil.sizeOfAsciiString(this.keyspace);
                if (this.target != Target.KEYSPACE) {
                    size += CBUtil.sizeOfAsciiString(this.name);
                }
                return size;
            }
            if (this.target == Target.TYPE) {
                return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfAsciiString(this.keyspace) + CBUtil.sizeOfAsciiString("");
            }
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfAsciiString(this.keyspace) + CBUtil.sizeOfAsciiString(this.target == Target.KEYSPACE ? "" : this.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append((Object)this.change).append(' ').append((Object)this.target).append(' ').append(this.keyspace);
            if (this.name != null) {
                sb.append('.').append(this.name);
            }
            if (this.argTypes != null) {
                sb.append(" (");
                Iterator<String> iter2 = this.argTypes.iterator();
                while (iter2.hasNext()) {
                    sb.append(iter2.next());
                    if (!iter2.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(')');
            }
            return sb.toString();
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.change, this.target, this.keyspace, this.name, this.argTypes});
        }

        public boolean equals(Object other) {
            if (!(other instanceof SchemaChange)) {
                return false;
            }
            SchemaChange scc = (SchemaChange)other;
            return Objects.equal((Object)this.change, (Object)scc.change) && Objects.equal((Object)this.target, (Object)scc.target) && Objects.equal(this.keyspace, scc.keyspace) && Objects.equal(this.name, scc.name) && Objects.equal(this.argTypes, scc.argTypes);
        }

        public static enum Target {
            KEYSPACE,
            TABLE,
            TYPE,
            FUNCTION,
            AGGREGATE;

        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends NodeEvent {
        public final Status status;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE, node);
            this.status = status;
        }

        public static StatusChange nodeUp(InetAddressAndPort address) {
            return new StatusChange(Status.UP, new InetSocketAddress(address.address, address.port));
        }

        public static StatusChange nodeDown(InetAddressAndPort address) {
            return new StatusChange(Status.DOWN, new InetSocketAddress(address.address, address.port));
        }

        private static StatusChange deserializeEvent(ByteBuf cb, ProtocolVersion version) {
            Status status = CBUtil.readEnumValue(Status.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new StatusChange(status, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeEnumValue(this.status, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(ProtocolVersion version) {
            return CBUtil.sizeOfEnumValue(this.status) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.status, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof StatusChange)) {
                return false;
            }
            StatusChange stc = (StatusChange)other;
            return Objects.equal((Object)this.status, (Object)stc.status) && Objects.equal(this.node, stc.node);
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends NodeEvent {
        public final Change change;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE, node);
            this.change = change;
        }

        public static TopologyChange newNode(InetAddressAndPort address) {
            return new TopologyChange(Change.NEW_NODE, new InetSocketAddress(address.address, address.port));
        }

        public static TopologyChange removedNode(InetAddressAndPort address) {
            return new TopologyChange(Change.REMOVED_NODE, new InetSocketAddress(address.address, address.port));
        }

        public static TopologyChange movedNode(InetAddressAndPort address) {
            return new TopologyChange(Change.MOVED_NODE, new InetSocketAddress(address.address, address.port));
        }

        private static TopologyChange deserializeEvent(ByteBuf cb, ProtocolVersion version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new TopologyChange(change, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeEnumValue(this.change, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(ProtocolVersion version) {
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.change, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof TopologyChange)) {
                return false;
            }
            TopologyChange tpc = (TopologyChange)other;
            return Objects.equal((Object)this.change, (Object)tpc.change) && Objects.equal(this.node, tpc.node);
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static abstract class NodeEvent
    extends Event {
        public final InetSocketAddress node;

        public InetAddressAndPort nodeAddressAndPort() {
            return InetAddressAndPort.getByAddressOverrideDefaults(this.node.getAddress(), this.node.getPort());
        }

        private NodeEvent(Type type, InetSocketAddress node) {
            super(type);
            this.node = node;
        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE(ProtocolVersion.V3),
        STATUS_CHANGE(ProtocolVersion.V3),
        SCHEMA_CHANGE(ProtocolVersion.V3),
        TRACE_COMPLETE(ProtocolVersion.V4);

        public final ProtocolVersion minimumVersion;

        private Type(ProtocolVersion minimumVersion) {
            this.minimumVersion = minimumVersion;
        }
    }
}

