/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.binlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.utils.binlog.BinLogArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletingArchiver
implements BinLogArchiver {
    private static final Logger logger = LoggerFactory.getLogger(DeletingArchiver.class);
    private final Queue<File> chronicleStoreFiles = new ConcurrentLinkedQueue<File>();
    private final long maxLogSize;
    private long bytesInStoreFiles;

    public DeletingArchiver(long maxLogSize) {
        Preconditions.checkArgument(maxLogSize > 0L, "maxLogSize must be > 0");
        this.maxLogSize = maxLogSize;
    }

    @Override
    public synchronized void onReleased(int cycle, File file) {
        this.chronicleStoreFiles.offer(file);
        this.bytesInStoreFiles += file.length();
        logger.debug("Chronicle store file {} rolled file size {}", (Object)file.getPath(), (Object)file.length());
        while (this.bytesInStoreFiles > this.maxLogSize & !this.chronicleStoreFiles.isEmpty()) {
            File toDelete = this.chronicleStoreFiles.poll();
            long toDeleteLength = toDelete.length();
            if (!toDelete.delete()) {
                logger.error("Failed to delete chronicle store file: {} store file size: {} bytes in store files: {}. You will need to clean this up manually or reset full query logging.", new Object[]{toDelete.getPath(), toDeleteLength, this.bytesInStoreFiles});
                continue;
            }
            this.bytesInStoreFiles -= toDeleteLength;
            logger.info("Deleted chronicle store file: {} store file size: {} bytes in store files: {} max log size: {}.", new Object[]{file.getPath(), toDeleteLength, this.bytesInStoreFiles, this.maxLogSize});
        }
    }

    @VisibleForTesting
    long getBytesInStoreFiles() {
        return this.bytesInStoreFiles;
    }

    @Override
    public void stop() {
    }
}

