/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.textpane;

import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.apache.cayenne.swing.components.textpane.style.SyntaxStyle;
import org.apache.cayenne.swing.components.textpane.style.TextPaneStyleMap;
import org.apache.cayenne.swing.components.textpane.style.TextPaneStyleTypes;
import org.apache.cayenne.swing.components.textpane.syntax.SQLSyntaxConstants;
import org.apache.cayenne.swing.components.textpane.syntax.SyntaxConstant;

public class TextPaneView
extends PlainView {
    private static HashMap<Pattern, SyntaxStyle> patternSyntaxStyle;
    private static Pattern patternComment;
    private static Pattern patternCommentStart;
    private static SyntaxStyle syntaxStyleComment;
    private static HashMap<Pattern, SyntaxStyle> patternValue;
    private static TextPaneStyleMap style;

    public TextPaneView(Element elem, SyntaxConstant syntaxConstants) {
        super(elem);
        this.getDocument().putProperty("tabSize", 4);
        if (patternSyntaxStyle.isEmpty()) {
            this.addConstants(syntaxConstants.getKEYWORDS(), TextPaneStyleTypes.KEYWORDS);
            this.addConstants(syntaxConstants.getKEYWORDS2(), TextPaneStyleTypes.KEYWORDS2);
            this.addConstants(syntaxConstants.getOPERATORS(), TextPaneStyleTypes.KEYWORDS);
            this.addConstants(syntaxConstants.getTYPES(), TextPaneStyleTypes.TYPE);
        }
        if (patternValue.isEmpty()) {
            patternValue.put(Pattern.compile("\\d+"), TextPaneView.style.syntaxStyleMap.get((Object)TextPaneStyleTypes.NUMBER));
        }
        patternComment = Pattern.compile("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", 66);
        patternCommentStart = Pattern.compile("/\\*.?", 66);
        syntaxStyleComment = TextPaneView.style.syntaxStyleMap.get((Object)TextPaneStyleTypes.COMMENT);
    }

    private void addConstants(String[] constants, TextPaneStyleTypes type) {
        for (String keyword : constants) {
            String patern = "(" + keyword + ")";
            patternSyntaxStyle.put(Pattern.compile(patern, 66), TextPaneView.style.syntaxStyleMap.get((Object)type));
        }
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        boolean lineComment = false;
        HashMap<Integer, Integer> comment = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> commentInLine = new HashMap<Integer, Integer>();
        StyledDocument doc = (StyledDocument)this.getDocument();
        String text = doc.getText(p0, p1 - p0);
        Segment segment = this.getLineBuffer();
        Matcher m = patternComment.matcher(doc.getText(0, doc.getLength()));
        int maxEnd = 0;
        while (m.find()) {
            comment.put(m.start(), m.end());
            if (maxEnd >= m.end()) continue;
            maxEnd = m.end();
        }
        Matcher m3 = patternCommentStart.matcher(doc.getText(0, doc.getLength()));
        while (m3.find()) {
            if (maxEnd >= m3.start()) continue;
            comment.put(m3.start(), doc.getLength());
            break;
        }
        for (Map.Entry entry : comment.entrySet()) {
            if (p0 >= (Integer)entry.getKey() && p1 <= (Integer)entry.getValue()) {
                lineComment = true;
                break;
            }
            if (p0 <= (Integer)entry.getKey() && p1 >= (Integer)entry.getValue()) {
                commentInLine.put((Integer)entry.getKey() - p0, (Integer)entry.getValue() - p0);
                continue;
            }
            if (p0 <= (Integer)entry.getKey() && p1 >= (Integer)entry.getKey() && p1 < (Integer)entry.getValue()) {
                commentInLine.put((Integer)entry.getKey() - p0, p1 - p0);
                continue;
            }
            if (p0 > (Integer)entry.getValue() || p1 < (Integer)entry.getValue() || p0 <= (Integer)entry.getKey()) continue;
            commentInLine.put(0, (Integer)entry.getValue() - p0);
        }
        TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, SyntaxStyle> syntaxStyleMap = new TreeMap<Integer, SyntaxStyle>();
        if (lineComment) {
            startMap.put(0, text.length());
            syntaxStyleMap.put(0, syntaxStyleComment);
        } else {
            boolean inComment;
            Matcher matcher;
            for (Map.Entry entry : commentInLine.entrySet()) {
                startMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
                syntaxStyleMap.put((Integer)entry.getKey(), syntaxStyleComment);
            }
            for (Map.Entry<Object, Object> entry : patternSyntaxStyle.entrySet()) {
                matcher = ((Pattern)entry.getKey()).matcher(text);
                while (matcher.find()) {
                    if (text.length() != matcher.end() && text.charAt(matcher.end()) != '\t' && text.charAt(matcher.end()) != ' ' && text.charAt(matcher.end()) != '\n' || matcher.start() != 0 && text.charAt(matcher.start() - 1) != '\t' && text.charAt(matcher.start() - 1) != '\n' && text.charAt(matcher.start() - 1) != ' ') continue;
                    inComment = false;
                    for (Map.Entry entryCommentInLine : commentInLine.entrySet()) {
                        if (matcher.start(1) < (Integer)entryCommentInLine.getKey() || matcher.end() > (Integer)entryCommentInLine.getValue()) continue;
                        inComment = true;
                    }
                    if (inComment) continue;
                    startMap.put(matcher.start(1), matcher.end());
                    syntaxStyleMap.put(matcher.start(1), (SyntaxStyle)entry.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : patternValue.entrySet()) {
                matcher = ((Pattern)entry.getKey()).matcher(text);
                while (matcher.find()) {
                    if (text.length() != matcher.end() && text.charAt(matcher.end()) != ' ' && text.charAt(matcher.end()) != ')' && text.charAt(matcher.end()) != '\t' && text.charAt(matcher.end()) != '\n' || matcher.start() != 0 && text.charAt(matcher.start() - 1) != '\t' && text.charAt(matcher.start() - 1) != ' ' && text.charAt(matcher.start() - 1) != '=' && text.charAt(matcher.start() - 1) != '(') continue;
                    inComment = false;
                    for (Map.Entry entryCommentInLine : commentInLine.entrySet()) {
                        if (matcher.start() < (Integer)entryCommentInLine.getKey() || matcher.end() > (Integer)entryCommentInLine.getValue()) continue;
                        inComment = true;
                    }
                    if (inComment) continue;
                    startMap.put(matcher.start(), matcher.end());
                    syntaxStyleMap.put(matcher.start(), (SyntaxStyle)entry.getValue());
                }
            }
        }
        int i = 0;
        for (Map.Entry entry : startMap.entrySet()) {
            int start = (Integer)entry.getKey();
            int end = (Integer)entry.getValue();
            if (i < start) {
                graphics.setColor(SQLSyntaxConstants.DEFAULT_COLOR);
                graphics.setFont(SQLSyntaxConstants.DEFAULT_FONT);
                doc.getText(p0 + i, start - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            graphics.setFont(((SyntaxStyle)syntaxStyleMap.get(start)).getFont());
            graphics.setColor(((SyntaxStyle)syntaxStyleMap.get(start)).getColor());
            i = end;
            doc.getText(p0 + start, i - start, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
        }
        if (i < text.length()) {
            graphics.setColor(SQLSyntaxConstants.DEFAULT_COLOR);
            graphics.setFont(SQLSyntaxConstants.DEFAULT_FONT);
            doc.getText(p0 + i, text.length() - i, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
        }
        return x;
    }

    static {
        style = new TextPaneStyleMap();
        patternSyntaxStyle = new HashMap();
        patternValue = new HashMap();
    }
}

