/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.Jdbc41Bridge;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;

public class ConnectionPoolDataSourceProxy
implements ConnectionPoolDataSource {
    protected ConnectionPoolDataSource delegate;

    public ConnectionPoolDataSourceProxy(ConnectionPoolDataSource cpds) {
        this.delegate = cpds;
    }

    public ConnectionPoolDataSource getDelegate() {
        return this.delegate;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Jdbc41Bridge.getParentLogger((CommonDataSource)this.delegate);
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.wrapPooledConnection(this.delegate.getPooledConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.wrapPooledConnection(this.delegate.getPooledConnection(user, password));
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    protected PooledConnection wrapPooledConnection(PooledConnection pc) {
        PooledConnectionProxy tpc = new PooledConnectionProxy(pc);
        tpc.setNotifyOnClose(true);
        return tpc;
    }
}

