/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiCARealiaModified$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiStandard$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiTandemModified$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiTranslatedEBCDIC$;
import org.apache.daffodil.lib.util.DecimalUtils$OverpunchLocation$;
import org.apache.daffodil.lib.util.PackedSignCodes;
import scala.Char$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DecimalUtils$
implements Serializable {
    private static final String B0_to_B9_chars;
    public static final DecimalUtils$OverpunchLocation$ OverpunchLocation;
    public static final DecimalUtils$ MODULE$;

    private DecimalUtils$() {
    }

    static {
        MODULE$ = new DecimalUtils$();
        B0_to_B9_chars = "^\u00a3\u00a5\u00b7\u00a9\u00a7\u00b6\u00bc\u00bd\u00be";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DecimalUtils$.class);
    }

    public BigInteger packedToBigInteger(byte[] num, PackedSignCodes signCodes) {
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(num);
        int numDigits = ArrayOps$.MODULE$.size$extension(object2) * 2;
        char[] outputData = new char[numDigits - 1];
        int outputPos = 0;
        int offset = 0;
        Object object3 = Predef$.MODULE$.byteArrayOps(num);
        int signNibble = num[offset + ArrayOps$.MODULE$.size$extension(object3) - 1] & 0xF;
        boolean negative = signCodes.negative().contains((Object)BoxesRunTime.boxToInteger((int)signNibble));
        if (!(negative || signCodes.positive().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.unsigned().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.zero_sign().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)))) {
            throw new NumberFormatException("Invalid sign nibble: " + signNibble);
        }
        while (outputPos < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.charArrayOps(outputData)) - 1) {
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException("Invalid high nibble: " + highNibble);
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = num[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException("Invalid low nibble: " + lowNibble);
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
            ++offset;
        }
        int lastNibble = (num[offset] & 0xFF) >>> 4;
        if (lastNibble > 9) {
            throw new NumberFormatException("Invalid high nibble: " + lastNibble);
        }
        outputData[outputPos] = (char)(lastNibble | 0x30);
        BigInteger jbi = new BigInteger(new String(outputData));
        if (negative) {
            return jbi.negate();
        }
        return jbi;
    }

    public BigDecimal packedToBigDecimal(byte[] num, int scale, PackedSignCodes signCodes) {
        return new BigDecimal(this.packedToBigInteger(num, signCodes), scale);
    }

    public Tuple2<Object, Object> packedFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? (numDigits + 2) * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits - 1 : bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] packedFromBigInteger(BigInteger bigInt, int minLengthInBits, PackedSignCodes signCodes) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.packedFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (numDigits % 2 == 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++inPos;
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        int lastNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
        int signNibble = negative ? BoxesRunTime.unboxToInt((Object)signCodes.negative().apply(0)) & 0xF : BoxesRunTime.unboxToInt((Object)signCodes.positive().apply(0)) & 0xF;
        outArray[offset] = (byte)(lastNibble + signNibble);
        return outArray;
    }

    public BigInteger bcdToBigInteger(byte[] bcdNum) {
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(bcdNum);
        int numDigits = ArrayOps$.MODULE$.size$extension(object2) * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        for (int offset = 0; offset < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.byteArrayOps(bcdNum)); ++offset) {
            int highNibble = (bcdNum[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException("Invalid high nibble: " + highNibble);
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = bcdNum[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException("Invalid low nibble: " + lowNibble);
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        return new BigInteger(new String(outputData));
    }

    public BigDecimal bcdToBigDecimal(byte[] bcdNum, int scale) {
        return new BigDecimal(this.bcdToBigInteger(bcdNum), scale);
    }

    public Tuple2<Object, Object> bcdFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] bcdFromBigInteger(BigInteger bigInt, int minLengthInBits) {
        String inChars = bigInt.toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.bcdFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (inChars.length() % 2 != 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++offset;
            ++inPos;
        }
        while (inPos < inChars.length()) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    public BigInteger ibm4690ToBigInteger(byte[] num) {
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(num);
        int numDigits = ArrayOps$.MODULE$.size$extension(object2) * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        boolean negative = false;
        boolean inDigits = false;
        for (int offset = 0; offset < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.byteArrayOps(num)); ++offset) {
            int lowNibble;
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                outputData[outputPos] = 48;
                if (highNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (highNibble != 15 || inDigits) {
                    throw new NumberFormatException("Invalid high nibble: " + highNibble);
                }
                ++outputPos;
            }
            if (highNibble <= 9) {
                inDigits = true;
                outputData[outputPos] = (char)(highNibble | 0x30);
                ++outputPos;
            }
            if ((lowNibble = num[offset] & 0xF) > 9) {
                outputData[outputPos] = 48;
                ++outputPos;
                if (lowNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (lowNibble != 15 || inDigits) {
                    throw new NumberFormatException("Invalid low nibble: " + lowNibble);
                }
            }
            if (lowNibble > 9) continue;
            inDigits = true;
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        BigInteger jbi = new BigInteger(new String(outputData));
        if (negative) {
            return jbi.negate();
        }
        return jbi;
    }

    public BigDecimal ibm4690ToBigDecimal(byte[] num, int scale) {
        return new BigDecimal(this.ibm4690ToBigInteger(num), scale);
    }

    public Tuple2<Object, Object> ibm4690FromBigIntegerLength(String absBigIntAsString, int minLengthInBits, boolean negative) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = negative ? absBigIntAsString.length() + 1 : absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits : bitLen / 4 - (numDigits + 1);
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] ibm4690FromBigInteger(BigInteger bigInt, int minLengthInBits) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = negative ? inChars.length() + 1 : inChars.length();
        Tuple2<Object, Object> tuple2 = this.ibm4690FromBigIntegerLength(inChars, minLengthInBits, negative);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        boolean wrote_negative = false;
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)255;
            ++offset;
        }
        if (numDigits % 2 != 0) {
            int n;
            int padNibble = 240;
            if (negative) {
                wrote_negative = true;
                n = 13;
            } else {
                n = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF;
            }
            int signNibble = n;
            outArray[offset] = (byte)(padNibble + signNibble);
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int n;
            if (negative && !wrote_negative) {
                wrote_negative = true;
                n = 208;
            } else {
                n = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF) << 4;
            }
            int firstNibble = n;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    public Tuple2<Object, Object> convertFromZonedEBCDIC(char digit) {
        if (digit >= '0' && digit <= '9') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 48)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit == '{') {
            return new Tuple2.mcIZ.sp(0, false);
        }
        if (digit >= 'A' && digit <= 'I') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 65 + 1)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit == '}') {
            return new Tuple2.mcIZ.sp(0, true);
        }
        if (digit >= 'J' && digit <= 'R') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 74 + 1)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        int index = B0_to_B9_chars.indexOf(Char$.MODULE$.char2int(digit));
        if (index >= 0) {
            return new Tuple2.mcIZ.sp(index, true);
        }
        throw new NumberFormatException("Invalid zoned digit: " + digit);
    }

    public Tuple2<Object, Object> convertFromAsciiStandard(char digit) {
        if (digit >= '0' && digit <= '9') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 48)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit >= 'p' && digit <= 'y') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 112)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new NumberFormatException("Invalid zoned digit: " + digit);
    }

    public char convertToAsciiStandard(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit + 64);
    }

    public Tuple2<Object, Object> convertFromAsciiTranslatedEBCDIC(char digit) {
        if (digit == '{') {
            return new Tuple2.mcIZ.sp(0, false);
        }
        if (digit == '}') {
            return new Tuple2.mcIZ.sp(0, true);
        }
        if (digit >= 'A' && digit <= 'I') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 64)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit >= 'J' && digit <= 'R') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 73)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (digit >= '0' && digit <= '9') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 48)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new NumberFormatException("Invalid zoned digit: " + digit);
    }

    public char convertToZonedEBCDIC(char digit, boolean positive) {
        int pos = digit - 48;
        if (pos > 9 || pos < 0) {
            throw new NumberFormatException("Invalid zoned digit: " + digit);
        }
        if (positive) {
            return "{ABCDEFGHI".charAt(pos);
        }
        return "}JKLMNOPQR".charAt(pos);
    }

    public char convertToAsciiTranslatedEBCDIC(char digit, boolean positive) {
        if (positive) {
            if (digit == '0') {
                return '{';
            }
            return (char)(digit + 16);
        }
        if (digit == '0') {
            return '}';
        }
        return (char)(digit + 25);
    }

    public Tuple2<Object, Object> convertFromAsciiCARealiaModified(char digit) {
        if (digit >= '0' && digit <= '9') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 48)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit >= ' ' && digit <= ')') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 32)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new NumberFormatException("Invalid zoned digit: " + digit);
    }

    public char convertToAsciiCARealiaModified(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit - 16);
    }

    public Tuple2<Object, Object> convertFromAsciiTandemModified(char digit) {
        if (digit >= '0' && digit <= '9') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 48)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (digit >= '\u0080' && digit <= '\u0089') {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(digit - 128)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new NumberFormatException("Invalid zoned digit: " + digit);
    }

    public char convertToAsciiTandemModified(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit + 80);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String zonedToNumber(String num, Option<TextZonedSignStyle> optZonedStyle, Enumeration.Value opl) {
        String string;
        Tuple2<Object, Object> tuple2;
        Object object;
        int n;
        Enumeration.Value value = opl;
        Enumeration.Value value2 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 0;
        } else {
            Enumeration.Value value4 = DecimalUtils$OverpunchLocation$.MODULE$.End();
            Enumeration.Value value5 = value;
            n = !(value4 != null ? !value4.equals(value5) : value5 != null) ? num.length() - 1 : -1;
        }
        int opindex = n;
        Enumeration.Value value6 = opl;
        Enumeration.Value value7 = DecimalUtils$OverpunchLocation$.MODULE$.None();
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            object = num;
            return object;
        }
        Option<TextZonedSignStyle> option = optZonedStyle;
        if (None$.MODULE$.equals(option)) {
            tuple2 = this.convertFromZonedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            TextZonedSignStyle textZonedSignStyle = (TextZonedSignStyle)((Some)option).value();
            if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(textZonedSignStyle)) {
                tuple2 = this.convertFromAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
            } else if (TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(textZonedSignStyle)) {
                tuple2 = this.convertFromAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
            } else if (TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(textZonedSignStyle)) {
                tuple2 = this.convertFromAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
            } else {
                if (!TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(textZonedSignStyle)) throw new MatchError(option);
                tuple2 = this.convertFromAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
            }
        }
        Tuple2<Object, Object> tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError(tuple22);
        int digit = tuple22._1$mcI$sp();
        boolean opneg = tuple22._2$mcZ$sp();
        Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(digit, opneg);
        int digit2 = sp2._1$mcI$sp();
        boolean opneg2 = sp2._2$mcZ$sp();
        Enumeration.Value value8 = opl;
        Enumeration.Value value9 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
        Enumeration.Value value10 = value8;
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            string = BoxesRunTime.boxToInteger((int)digit2).toString() + num.substring(1);
        } else {
            Enumeration.Value value11 = DecimalUtils$OverpunchLocation$.MODULE$.End();
            Enumeration.Value value12 = value8;
            if (value11 == null) {
                if (value12 != null) {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            } else if (!value11.equals(value12)) throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            string = num.substring(0, opindex) + digit2;
        }
        String allDigits = string;
        String convertedNum = opneg2 ? "-" + allDigits : allDigits;
        object = convertedNum;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String zonedFromNumber(String num, Option<TextZonedSignStyle> optZonedStyle, Enumeration.Value opl) {
        String convertedNum;
        Object object;
        char c;
        String string;
        int n;
        String string2;
        boolean positive = num.charAt(0) != '-';
        boolean bl = positive;
        if (bl) {
            string2 = num;
        } else {
            if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            string2 = num.substring(1);
        }
        String inStr = string2;
        Enumeration.Value value = opl;
        Enumeration.Value value2 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 0;
        } else {
            Enumeration.Value value4 = DecimalUtils$OverpunchLocation$.MODULE$.End();
            Enumeration.Value value5 = value;
            n = !(value4 != null ? !value4.equals(value5) : value5 != null) ? inStr.length() - 1 : -1;
        }
        int opindex = n;
        Enumeration.Value value6 = opl;
        Enumeration.Value value7 = DecimalUtils$OverpunchLocation$.MODULE$.None();
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            if (!positive) {
                throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            }
            string = inStr;
            return string;
        }
        Option<TextZonedSignStyle> option = optZonedStyle;
        if (None$.MODULE$.equals(option)) {
            c = this.convertToZonedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            TextZonedSignStyle textZonedSignStyle = (TextZonedSignStyle)((Some)option).value();
            if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else if (TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else if (TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else {
                if (!TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(textZonedSignStyle)) throw new MatchError(option);
                c = this.convertToAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            }
        }
        char digit = c;
        Enumeration.Value value8 = opl;
        Enumeration.Value value9 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
        Enumeration.Value value10 = value8;
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            object = StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(inStr.substring(1)), digit);
        } else {
            Enumeration.Value value11 = DecimalUtils$OverpunchLocation$.MODULE$.End();
            Enumeration.Value value12 = value8;
            if (value11 == null) {
                if (value12 != null) {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            } else if (!value11.equals(value12)) throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            object = inStr.substring(0, opindex) + digit;
        }
        string = convertedNum = object;
        return string;
    }
}

