---
{
"title": "INET_ATON",
"language": "en"
}
---

<!-- 
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at
  http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## INET_ATON

<version since="dev">

inet_aton

</version>

### description

#### Syntax

`BIGINT INET_ATON(VARCHAR ipv4_string)`

Takes a string containing an IPv4 address in the format A.B.C.D (dot-separated numbers in decimal form). Returns a BIGINT number representing the corresponding IPv4 address in big endian.

### notice

`It is the alias of ipv4_string_to_num_or_null. 
It will return NULL if the input string is not a valid IP address or NULL, which is the same with MySQL`

### example
```
mysql> select inet_aton('192.168.0.1'); 
+-------------------------------------------+ 
| ipv4_string_to_num_or_null('192.168.0.1') | 
+-------------------------------------------+ 
| 3232235521                                | 
+-------------------------------------------+ 
1 row in set (0.01 sec)

mysql> SELECT inet_aton('192.168');
+---------------------------------------+ 
| ipv4_string_to_num_or_null('192.168') | 
+---------------------------------------+ 
| NULL                                  | 
+---------------------------------------+ 
1 row in set (0.01 sec)
```

### keywords

INET_ATON, IP