CREATE TABLE debezium_ingestion_msg.full_types_tab
(
    `id`                   LARGEINT      NULL,
    `tiny_c`               TINYINT       NULL,
    `tiny_un_c`            SMALLINT      NULL,
    `tiny_un_z_c`          SMALLINT      NULL,
    `small_c`              SMALLINT      NULL,
    `small_un_c`           INT           NULL,
    `small_un_z_c`         INT           NULL,
    `medium_c`             INT           NULL,
    `medium_un_c`          BIGINT        NULL,
    `medium_un_z_c`        BIGINT        NULL,
    `int_c`                INT           NULL,
    `int_un_c`             BIGINT        NULL,
    `int_un_z_c`           BIGINT        NULL,
    `int11_c`              INT           NULL,
    `big_c`                BIGINT        NULL,
    `big_un_c`             LARGEINT      NULL,
    `big_un_z_c`           LARGEINT      NULL,
    `varchar_c`            VARCHAR(765)  NULL,
    `char_c`               VARCHAR(9)    NULL,
    `real_c`               DOUBLE        NULL,
    `float_c`              FLOAT         NULL,
    `float_un_c`           FLOAT         NULL,
    `float_un_z_c`         FLOAT         NULL,
    `double_c`             DOUBLE        NULL,
    `double_un_c`          DOUBLE        NULL,
    `double_un_z_c`        DOUBLE        NULL,
    `decimal_c`            DECIMAL(8, 4) NULL,
    `decimal_un_c`         DECIMAL(8, 4) NULL,
    `decimal_un_z_c`       DECIMAL(8, 4) NULL,
    `numeric_c`            DECIMAL(6, 0) NULL,
    `big_decimal_c`        TEXT          NULL,
    `bit1_c`               BOOLEAN       NULL,
    `tiny1_c`              BOOLEAN       NULL,
    `boolean_c`            BOOLEAN       NULL,
    `date_c`               DATE          NULL,
    `time_c`               TEXT          NULL,
    `datetime_c`           DATETIME      NULL,
    `timestamp_c`          DATETIME      NULL,
    `text_c`               TEXT          NULL,
    `year_c`               INT           NULL,
    `enum_c`               TEXT          NULL,
    `set_c`                TEXT          NULL,
    `json_c`               JSON          NULL,
    `point_c`              TEXT          NULL,
    `geometry_c`           TEXT          NULL,
    `linestring_c`         TEXT          NULL,
    `polygon_c`            TEXT          NULL,
    `multipoint_c`         TEXT          NULL,
    `multiline_c`          TEXT          NULL,
    `multipolygon_c`       TEXT          NULL,
    `geometrycollection_c` TEXT          NULL
)UNIQUE KEY(`id`)
DISTRIBUTED BY HASH(`id`) BUCKETS 1
PROPERTIES (
"replication_allocation" = "tag.location.default: 1",
"light_schema_change" = "true"
);