/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimateWithErrorBounds;
import org.apache.druid.segment.data.SafeWritableMemory;

public class SketchHolder {
    public static final SketchHolder EMPTY = SketchHolder.of(Sketches.updateSketchBuilder().build().compact(true, null));
    public static final Comparator<Object> COMPARATOR = Ordering.from((Comparator)new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            SketchHolder h1 = (SketchHolder)o1;
            SketchHolder h2 = (SketchHolder)o2;
            if (h1.obj instanceof Sketch || h1.obj instanceof Union) {
                if (h2.obj instanceof Sketch || h2.obj instanceof Union) {
                    return SKETCH_COMPARATOR.compare(h1.getSketch(), h2.getSketch());
                }
                return -1;
            }
            if (h1.obj instanceof Memory) {
                if (h2.obj instanceof Memory) {
                    return MEMORY_COMPARATOR.compare((Memory)h1.obj, (Memory)h2.obj);
                }
                return 1;
            }
            throw new IAE("Unknwon types [%s] and [%s]", new Object[]{h1.obj.getClass().getName(), h2.obj.getClass().getName()});
        }
    }).nullsFirst();
    private static final Comparator<Sketch> SKETCH_COMPARATOR = new Comparator<Sketch>(){

        @Override
        public int compare(Sketch o1, Sketch o2) {
            return Doubles.compare((double)o1.getEstimate(), (double)o2.getEstimate());
        }
    };
    private static final Comparator<Memory> MEMORY_COMPARATOR = new Comparator<Memory>(){

        @Override
        public int compare(Memory o1, Memory o2) {
            int retVal = Longs.compare((long)o1.getCapacity(), (long)o2.getCapacity());
            if (retVal == 0) {
                retVal = Longs.compare((long)o1.getLong(o2.getCapacity() - 8L), (long)o2.getLong(o2.getCapacity() - 8L));
            }
            return retVal;
        }
    };
    private final Object obj;
    @Nullable
    private volatile Double cachedEstimate = null;
    @Nullable
    private volatile Sketch cachedSketch = null;

    private SketchHolder(Object obj) {
        Preconditions.checkArgument((obj instanceof Sketch || obj instanceof Union || obj instanceof Memory ? 1 : 0) != 0, (String)"unknown sketch representation type [%s]", (Object)obj.getClass().getName());
        this.obj = obj;
    }

    public static SketchHolder of(Object obj) {
        return new SketchHolder(obj);
    }

    public void updateUnion(Union union) {
        if (this.obj instanceof Memory) {
            union.union((Memory)this.obj);
        } else {
            union.union(this.getSketch());
        }
    }

    public Sketch getSketch() {
        if (this.cachedSketch != null) {
            return this.cachedSketch;
        }
        if (this.obj instanceof Sketch) {
            this.cachedSketch = (Sketch)this.obj;
        } else if (this.obj instanceof Union) {
            this.cachedSketch = ((Union)this.obj).getResult();
        } else if (this.obj instanceof Memory) {
            this.cachedSketch = SketchHolder.deserializeFromMemory((Memory)this.obj);
        } else {
            throw new ISE("Can't get sketch from object of type [%s]", new Object[]{this.obj.getClass().getName()});
        }
        return this.cachedSketch;
    }

    public double getEstimate() {
        if (this.cachedEstimate == null) {
            this.cachedEstimate = this.getSketch().getEstimate();
        }
        return this.cachedEstimate;
    }

    public SketchEstimateWithErrorBounds getEstimateWithErrorBounds(int errorBoundsStdDev) {
        Sketch sketch = this.getSketch();
        SketchEstimateWithErrorBounds result = new SketchEstimateWithErrorBounds(this.getEstimate(), sketch.getUpperBound(errorBoundsStdDev), sketch.getLowerBound(errorBoundsStdDev), errorBoundsStdDev);
        return result;
    }

    public static SketchHolder combine(Object o1, Object o2, int nomEntries) {
        SketchHolder holder1 = (SketchHolder)o1;
        SketchHolder holder2 = (SketchHolder)o2;
        if (holder1.obj instanceof Union) {
            Union union = (Union)holder1.obj;
            holder2.updateUnion(union);
            holder1.invalidateCache();
            return holder1;
        }
        if (holder2.obj instanceof Union) {
            Union union = (Union)holder2.obj;
            holder1.updateUnion(union);
            holder2.invalidateCache();
            return holder2;
        }
        Union union = (Union)SetOperation.builder().setNominalEntries(nomEntries).build(Family.UNION);
        holder1.updateUnion(union);
        holder2.updateUnion(union);
        return SketchHolder.of(union);
    }

    void invalidateCache() {
        this.cachedEstimate = null;
        this.cachedSketch = null;
    }

    public static SketchHolder deserialize(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return SketchHolder.of(SketchHolder.deserializeFromBase64EncodedString((String)serializedSketch));
        }
        if (serializedSketch instanceof byte[]) {
            return SketchHolder.of(SketchHolder.deserializeFromByteArray((byte[])serializedSketch));
        }
        if (serializedSketch instanceof SketchHolder) {
            return (SketchHolder)serializedSketch;
        }
        if (serializedSketch instanceof Sketch || serializedSketch instanceof Union || serializedSketch instanceof Memory) {
            return SketchHolder.of(serializedSketch);
        }
        throw new ISE("Object is not of a type[%s] that can be deserialized to sketch.", new Object[]{serializedSketch.getClass()});
    }

    public static SketchHolder deserializeSafe(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return SketchHolder.of(SketchHolder.deserializeFromBase64EncodedStringSafe((String)serializedSketch));
        }
        if (serializedSketch instanceof byte[]) {
            return SketchHolder.of(SketchHolder.deserializeFromByteArraySafe((byte[])serializedSketch));
        }
        return SketchHolder.deserialize(serializedSketch);
    }

    private static Sketch deserializeFromBase64EncodedString(String str) {
        return SketchHolder.deserializeFromByteArray(StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)str)));
    }

    private static Sketch deserializeFromByteArray(byte[] data) {
        return SketchHolder.deserializeFromMemory(Memory.wrap((byte[])data));
    }

    private static Sketch deserializeFromBase64EncodedStringSafe(String str) {
        return SketchHolder.deserializeFromByteArraySafe(StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)str)));
    }

    private static Sketch deserializeFromByteArraySafe(byte[] data) {
        return SketchHolder.deserializeFromMemory((Memory)SafeWritableMemory.wrap((byte[])data));
    }

    private static Sketch deserializeFromMemory(Memory mem) {
        if (Sketch.getSerializationVersion((Memory)mem) < 3) {
            return Sketches.heapifySketch((Memory)mem);
        }
        return Sketches.wrapSketch((Memory)mem);
    }

    public static SketchHolder sketchSetOperation(Func func, int sketchSize, Object ... holders) {
        switch (func) {
            case UNION: {
                Union union = (Union)SetOperation.builder().setNominalEntries(sketchSize).build(Family.UNION);
                for (Object o : holders) {
                    ((SketchHolder)o).updateUnion(union);
                }
                return SketchHolder.of(union);
            }
            case INTERSECT: {
                Intersection intersection = (Intersection)SetOperation.builder().setNominalEntries(sketchSize).build(Family.INTERSECTION);
                for (Object o : holders) {
                    intersection.intersect(((SketchHolder)o).getSketch());
                }
                return SketchHolder.of(intersection.getResult(false, null));
            }
            case NOT: {
                if (holders.length < 1) {
                    throw new IllegalArgumentException("A-Not-B requires at least 1 sketch");
                }
                if (holders.length == 1) {
                    return (SketchHolder)holders[0];
                }
                Sketch result = ((SketchHolder)holders[0]).getSketch();
                for (int i = 1; i < holders.length; ++i) {
                    AnotB anotb = (AnotB)SetOperation.builder().setNominalEntries(sketchSize).build(Family.A_NOT_B);
                    result = anotb.aNotB(result, ((SketchHolder)holders[i]).getSketch());
                }
                return SketchHolder.of(result);
            }
        }
        throw new IllegalArgumentException("Unknown sketch operation " + func);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.getSketch().toByteArray(), ((SketchHolder)o).getSketch().toByteArray());
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getSketch().toByteArray());
    }

    public static enum Func {
        UNION,
        INTERSECT,
        NOT;

    }
}

